/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import java.util.Arrays;
import java.util.List;
import org.joda.time.Instant;

public class Repeatedly<W extends BoundedWindow>
extends Trigger<W> {
    private static final int REPEATED = 0;

    public static <W extends BoundedWindow> Repeatedly<W> forever(Trigger<W> repeated) {
        return new Repeatedly<W>(repeated);
    }

    private Repeatedly(Trigger<W> repeated) {
        super(Arrays.asList(repeated));
    }

    @Override
    public Trigger.TriggerResult onElement(Trigger.OnElementContext c) throws Exception {
        Trigger.TriggerResult result = c.trigger().subTrigger(0).invokeElement(c);
        if (result.isFinish()) {
            c.forTrigger(c.trigger().subTrigger(0)).trigger().resetTree();
        }
        return result.isFire() ? Trigger.TriggerResult.FIRE : Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.MergeResult onMerge(Trigger.OnMergeContext c) throws Exception {
        Trigger.MergeResult mergeResult = c.trigger().subTrigger(0).invokeMerge(c);
        if (mergeResult.isFinish()) {
            ((Trigger.OnMergeContext)c.forTrigger(c.trigger().subTrigger(0))).trigger().resetTree();
        }
        return mergeResult.isFire() ? Trigger.MergeResult.FIRE : Trigger.MergeResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onTimer(Trigger.OnTimerContext c) throws Exception {
        Trigger.TriggerResult result = c.trigger().subTrigger(0).invokeTimer(c);
        if (result.isFinish()) {
            c.forTrigger(c.trigger().subTrigger(0)).trigger().resetTree();
        }
        return result.isFire() ? Trigger.TriggerResult.FIRE : Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(W window) {
        return ((Trigger)this.subTriggers.get(0)).getWatermarkThatGuaranteesFiring(window);
    }

    @Override
    public Trigger<W> getContinuationTrigger(List<Trigger<W>> continuationTriggers) {
        return new Repeatedly<W>(continuationTriggers.get(0));
    }
}

