/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.transforms.windowing;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.InstantCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.transforms.Min;
import com.google.cloud.dataflow.sdk.transforms.SerializableFunction;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.state.CombiningValueState;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.StateTags;
import java.util.List;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

@Experimental(value=Experimental.Kind.TRIGGER)
public abstract class TimeTrigger<W extends BoundedWindow>
extends Trigger.OnceTrigger<W> {
    protected static final StateTag<CombiningValueState<Instant, Instant>> DELAYED_UNTIL_TAG = StateTags.makeSystemTagInternal(StateTags.combiningValueFromInputInternal("delayed", InstantCoder.of(), Min.MinFn.naturalOrder()));
    protected static final List<SerializableFunction<Instant, Instant>> IDENTITY = ImmutableList.of();
    protected final List<SerializableFunction<Instant, Instant>> timestampMappers;

    protected TimeTrigger(List<SerializableFunction<Instant, Instant>> timestampMappers) {
        super(null);
        this.timestampMappers = timestampMappers;
    }

    protected Instant computeTargetTimestamp(Instant time) {
        Instant result = time;
        for (SerializableFunction<Instant, Instant> timestampMapper : this.timestampMappers) {
            result = timestampMapper.apply(result);
        }
        return result;
    }

    public TimeTrigger<W> plusDelayOf(Duration delay) {
        return this.newWith(TimeTrigger.delayFn(delay));
    }

    private static SerializableFunction<Instant, Instant> delayFn(final Duration delay) {
        return new SerializableFunction<Instant, Instant>(){

            @Override
            public Instant apply(Instant input) {
                return input.plus((ReadableDuration)delay);
            }
        };
    }

    public TimeTrigger<W> alignedTo(Duration size, Instant offset) {
        return this.newWith(TimeTrigger.alignFn(size, offset));
    }

    private static SerializableFunction<Instant, Instant> alignFn(final Duration size, final Instant offset) {
        return new SerializableFunction<Instant, Instant>(){

            @Override
            public Instant apply(Instant point) {
                long millisSinceStart = new Duration((ReadableInstant)offset, (ReadableInstant)point).getMillis() % size.getMillis();
                return millisSinceStart == 0L ? point : point.plus((ReadableDuration)size).minus(millisSinceStart);
            }
        };
    }

    public TimeTrigger<W> alignedTo(Duration size) {
        return this.alignedTo(size, new Instant(0L));
    }

    public TimeTrigger<W> mappedTo(SerializableFunction<Instant, Instant> timestampMapper) {
        return this.newWith(timestampMapper);
    }

    @Override
    public boolean isCompatible(Trigger<?> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        TimeTrigger that = (TimeTrigger)other;
        return this.timestampMappers.equals(that.timestampMappers);
    }

    private TimeTrigger<W> newWith(SerializableFunction<Instant, Instant> timestampMapper) {
        return this.newWith((List<SerializableFunction<Instant, Instant>>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.timestampMappers)).add(timestampMapper)).build()));
    }

    protected abstract TimeTrigger<W> newWith(List<SerializableFunction<Instant, Instant>> var1);
}

