/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.client.util.BackOff;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;

public class AttemptBoundedExponentialBackOff
implements BackOff {
    public static final double DEFAULT_MULTIPLIER = 1.5;
    public static final double DEFAULT_RANDOMIZATION_FACTOR = 0.5;
    private final int maximumNumberOfAttempts;
    private final long initialIntervalMillis;
    private int currentAttempt;

    public AttemptBoundedExponentialBackOff(int maximumNumberOfAttempts, long initialIntervalMillis) {
        Preconditions.checkArgument(maximumNumberOfAttempts > 0, "Maximum number of attempts must be greater than zero.");
        Preconditions.checkArgument(initialIntervalMillis > 0L, "Initial interval must be greater than zero.");
        this.maximumNumberOfAttempts = maximumNumberOfAttempts;
        this.initialIntervalMillis = initialIntervalMillis;
        this.reset();
    }

    public void reset() {
        this.currentAttempt = 1;
    }

    public long nextBackOffMillis() {
        if (this.currentAttempt >= this.maximumNumberOfAttempts) {
            return -1L;
        }
        double currentIntervalMillis = (double)this.initialIntervalMillis * Math.pow(1.5, this.currentAttempt - 1);
        double randomOffset = (Math.random() * 2.0 - 1.0) * 0.5 * currentIntervalMillis;
        ++this.currentAttempt;
        return Math.round(currentIntervalMillis + randomOffset);
    }

    public boolean atMaxAttempts() {
        return this.currentAttempt >= this.maximumNumberOfAttempts;
    }
}

