/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.services.dataflow.model.SideInputInfo;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsFactory;
import com.google.cloud.dataflow.sdk.runners.worker.DataflowExecutionContext;
import com.google.cloud.dataflow.sdk.runners.worker.DataflowSideInputReader;
import com.google.cloud.dataflow.sdk.util.BaseExecutionContext;
import com.google.cloud.dataflow.sdk.util.ExecutionContext;
import com.google.cloud.dataflow.sdk.util.SideInputReader;
import com.google.cloud.dataflow.sdk.util.TimerInternals;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;
import com.google.cloud.dataflow.sdk.util.state.InMemoryStateInternals;
import com.google.cloud.dataflow.sdk.util.state.StateInternals;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import java.util.Objects;

public class BatchModeExecutionContext
extends DataflowExecutionContext {
    private Object key;
    private PipelineOptions options;

    protected BatchModeExecutionContext(PipelineOptions options) {
        this.options = options;
    }

    public static BatchModeExecutionContext withDefaultOptions() {
        return new BatchModeExecutionContext(PipelineOptionsFactory.create());
    }

    public static BatchModeExecutionContext fromOptions(PipelineOptions options) {
        return new BatchModeExecutionContext(options);
    }

    @Override
    protected ExecutionContext.StepContext createStepContext(String stepName, String transformName, StateSampler stateSampler) {
        return new StepContext(stepName, transformName);
    }

    public void setKey(Object key) {
        if (!Objects.equals(key, this.key)) {
            this.switchStateKey(key);
        }
        this.key = key;
    }

    protected void switchStateKey(Object newKey) {
        for (ExecutionContext.StepContext stepContext : this.getAllStepContexts()) {
            InMemoryStateInternals stateInternals = (InMemoryStateInternals)stepContext.stateInternals();
            stateInternals.clear();
        }
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public SideInputReader getSideInputReader(Iterable<? extends SideInputInfo> sideInputInfos) throws Exception {
        return DataflowSideInputReader.of(sideInputInfos, this.options, this);
    }

    @Override
    public SideInputReader getSideInputReaderForViews(Iterable<? extends PCollectionView<?>> views) throws Exception {
        throw new UnsupportedOperationException("BatchModeExecutionContext.withoutSideInputs().getSideInputReaderForViews(...)");
    }

    class StepContext
    extends BaseExecutionContext.StepContext {
        private final InMemoryStateInternals stateInternals;

        private StepContext(String stepName, String transformName) {
            super(BatchModeExecutionContext.this, stepName, transformName);
            this.stateInternals = new InMemoryStateInternals();
        }

        @Override
        public StateInternals stateInternals() {
            return this.stateInternals;
        }

        @Override
        public TimerInternals timerInternals() {
            throw new UnsupportedOperationException("Batch mode cannot return timerInternals");
        }
    }
}

