/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.ReduceFnRunner;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import com.google.cloud.dataflow.sdk.util.TimerInternals;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class BatchTimerInternals
implements TimerInternals {
    private Set<TimerInternals.TimerData> existingTimers = new HashSet<TimerInternals.TimerData>();
    private PriorityQueue<TimerInternals.TimerData> watermarkTimers = new PriorityQueue(11);
    private PriorityQueue<TimerInternals.TimerData> processingTimers = new PriorityQueue(11);
    private Instant watermarkTime;
    private Instant processingTime;

    private PriorityQueue<TimerInternals.TimerData> queue(TimeDomain domain) {
        return TimeDomain.EVENT_TIME.equals((Object)domain) ? this.watermarkTimers : this.processingTimers;
    }

    public BatchTimerInternals(Instant processingTime) {
        this.processingTime = processingTime;
        this.watermarkTime = BoundedWindow.TIMESTAMP_MIN_VALUE;
    }

    @Override
    public void setTimer(TimerInternals.TimerData timer) {
        if (this.existingTimers.add(timer)) {
            this.queue(timer.getDomain()).add(timer);
        }
    }

    @Override
    public void deleteTimer(TimerInternals.TimerData timer) {
        this.existingTimers.remove(timer);
        this.queue(timer.getDomain()).remove(timer);
    }

    @Override
    public Instant currentProcessingTime() {
        return this.processingTime;
    }

    @Override
    public Instant currentWatermarkTime() {
        return this.watermarkTime;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("watermarkTimers", this.watermarkTimers).add("processingTimers", this.processingTimers).toString();
    }

    public void advanceWatermark(ReduceFnRunner<?, ?, ?, ?> runner, Instant newWatermark) {
        this.watermarkTime = newWatermark;
        this.advance(runner, newWatermark, TimeDomain.EVENT_TIME);
    }

    public void advanceProcessingTime(ReduceFnRunner<?, ?, ?, ?> runner, Instant newProcessingTime) {
        this.processingTime = newProcessingTime;
        this.advance(runner, newProcessingTime, TimeDomain.PROCESSING_TIME);
    }

    private void advance(ReduceFnRunner<?, ?, ?, ?> runner, Instant newTime, TimeDomain domain) {
        PriorityQueue<TimerInternals.TimerData> timers = this.queue(domain);
        boolean shouldFire = false;
        do {
            TimerInternals.TimerData timer;
            boolean bl = shouldFire = (timer = timers.peek()) != null && !newTime.isBefore((ReadableInstant)timer.getTimestamp());
            if (!shouldFire) continue;
            timers.remove();
            runner.onTimer(timer);
        } while (shouldFire);
    }
}

