/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.Data;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.AttemptBoundedExponentialBackOff;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import org.joda.time.Duration;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryTableRowIterator
implements Iterator<TableRow>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryTableRowIterator.class);
    private final Bigquery client;
    private TableReference ref;
    private final String projectId;
    private TableSchema schema;
    private String pageToken;
    private Iterator<TableRow> rowIterator;
    private boolean lastPage = false;
    private static final int MAX_RETRIES = 3;
    private static final Duration INITIAL_BACKOFF_TIME = Duration.standardSeconds((long)1L);
    private static final Duration QUERY_COMPLETION_POLL_TIME = Duration.standardSeconds((long)1L);
    private final String query;
    private String temporaryDatasetId = null;
    private String temporaryTableId = null;

    public BigQueryTableRowIterator(Bigquery client, TableReference ref) {
        this.client = client;
        this.ref = ref;
        this.query = null;
        this.projectId = ref.getProjectId();
    }

    public BigQueryTableRowIterator(Bigquery client, String query, String projectId) {
        this.client = client;
        this.ref = null;
        this.query = query;
        this.projectId = projectId;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.rowIterator == null || !this.rowIterator.hasNext() && !this.lastPage) {
                this.readNext();
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this.rowIterator.hasNext();
    }

    private Object getTypedCellValue(TableFieldSchema fieldSchema, Object v) {
        if (Data.isNull((Object)v)) {
            return null;
        }
        if (Objects.equals(fieldSchema.getMode(), "REPEATED")) {
            TableFieldSchema elementSchema = fieldSchema.clone().setMode("REQUIRED");
            List rawValues = (List)v;
            ArrayList<Object> values = new ArrayList<Object>(rawValues.size());
            for (Map element : rawValues) {
                values.add(this.getTypedCellValue(elementSchema, element.get("v")));
            }
            return values;
        }
        if (fieldSchema.getType().equals("RECORD")) {
            Map typedV = (Map)v;
            return this.getTypedTableRow(fieldSchema.getFields(), typedV);
        }
        if (fieldSchema.getType().equals("FLOAT")) {
            return Double.parseDouble((String)v);
        }
        if (fieldSchema.getType().equals("BOOLEAN")) {
            return Boolean.parseBoolean((String)v);
        }
        if (fieldSchema.getType().equals("TIMESTAMP")) {
            long milliSecs = new Double(Double.parseDouble((String)v) * 1000.0).longValue();
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS").withZoneUTC();
            return String.valueOf(formatter.print(milliSecs)).concat(" UTC");
        }
        return v;
    }

    private TableRow getTypedTableRow(List<TableFieldSchema> fields, Map<String, Object> rawRow) {
        List cells = (List)rawRow.get("f");
        Preconditions.checkState(cells.size() == fields.size());
        Iterator cellIt = cells.iterator();
        Iterator<TableFieldSchema> fieldIt = fields.iterator();
        TableRow row = new TableRow();
        while (cellIt.hasNext()) {
            Map cell = (Map)cellIt.next();
            TableFieldSchema fieldSchema = fieldIt.next();
            row.set(fieldSchema.getName(), this.getTypedCellValue(fieldSchema, cell.get("v")));
        }
        return row;
    }

    @Override
    public TableRow next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.getTypedTableRow(this.schema.getFields(), (Map)this.rowIterator.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void createDataset(String datasetId) throws IOException, InterruptedException {
        Dataset dataset = new Dataset();
        DatasetReference reference = new DatasetReference();
        reference.setProjectId(this.projectId);
        reference.setDatasetId(datasetId);
        dataset.setDatasetReference(reference);
        String string = this.projectId;
        String createDatasetError = new StringBuilder(62 + String.valueOf(datasetId).length() + String.valueOf(string).length()).append("Error when trying to create the temporary dataset ").append(datasetId).append(" in project ").append(string).toString();
        BigQueryTableRowIterator.executeWithBackOff(this.client.datasets().insert(this.projectId, dataset), String.valueOf(createDatasetError).concat(" :{}"), new Object[0]);
    }

    private void deleteTable(String datasetId, String tableId) throws IOException, InterruptedException {
        String string = this.projectId;
        BigQueryTableRowIterator.executeWithBackOff(this.client.tables().delete(this.projectId, datasetId, tableId), new StringBuilder(125 + String.valueOf(datasetId).length() + String.valueOf(datasetId).length() + String.valueOf(string).length()).append("Error when trying to delete the temporary table ").append(datasetId).append(" in dataset ").append(datasetId).append(" of project ").append(string).append(". Manual deletion may be required. Error message : {}").toString(), new Object[0]);
    }

    private void deleteDataset(String datasetId) throws IOException, InterruptedException {
        String string = this.projectId;
        BigQueryTableRowIterator.executeWithBackOff(this.client.datasets().delete(this.projectId, datasetId), new StringBuilder(115 + String.valueOf(datasetId).length() + String.valueOf(string).length()).append("Error when trying to delete the temporary dataset ").append(datasetId).append(" in project ").append(string).append(". Manual deletion may be required. Error message : {}").toString(), new Object[0]);
    }

    private TableReference executeQueryAndWaitForCompletion() throws IOException, InterruptedException {
        Random rnd = new Random(System.currentTimeMillis());
        int n = rnd.nextInt(1000000);
        this.temporaryDatasetId = new StringBuilder(39).append("_dataflow_temporary_dataset_").append(n).toString();
        n = rnd.nextInt(1000000);
        this.temporaryTableId = new StringBuilder(36).append("dataflow_temporary_table_").append(n).toString();
        this.createDataset(this.temporaryDatasetId);
        Job job = new Job();
        JobConfiguration config = new JobConfiguration();
        JobConfigurationQuery queryConfig = new JobConfigurationQuery();
        config.setQuery(queryConfig);
        job.setConfiguration(config);
        queryConfig.setQuery(this.query);
        queryConfig.setAllowLargeResults(Boolean.valueOf(true));
        TableReference destinationTable = new TableReference();
        destinationTable.setProjectId(this.projectId);
        destinationTable.setDatasetId(this.temporaryDatasetId);
        destinationTable.setTableId(this.temporaryTableId);
        queryConfig.setDestinationTable(destinationTable);
        Bigquery.Jobs.Insert insert = this.client.jobs().insert(this.projectId, job);
        String string = this.query;
        Job queryJob = (Job)BigQueryTableRowIterator.executeWithBackOff(insert, new StringBuilder(51 + String.valueOf(string).length()).append("Error when trying to execute the job for query ").append(string).append(" :{}").toString(), new Object[0]);
        JobReference jobId = queryJob.getJobReference();
        while (true) {
            String string2 = this.query;
            Job pollJob = (Job)BigQueryTableRowIterator.executeWithBackOff(this.client.jobs().get(this.projectId, jobId.getJobId()), new StringBuilder(57 + String.valueOf(string2).length()).append("Error when trying to get status of the job for query ").append(string2).append(" :{}").toString(), new Object[0]);
            if (pollJob.getStatus().getState().equals("DONE")) {
                return pollJob.getConfiguration().getQuery().getDestinationTable();
            }
            try {
                Thread.sleep(QUERY_COMPLETION_POLL_TIME.getMillis());
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static <T> T executeWithBackOff(AbstractGoogleClientRequest<T> client, String error, Object ... errorArgs) throws IOException, InterruptedException {
        Sleeper sleeper = Sleeper.DEFAULT;
        AttemptBoundedExponentialBackOff backOff = new AttemptBoundedExponentialBackOff(3, INITIAL_BACKOFF_TIME.getMillis());
        Object result = null;
        while (true) {
            try {
                result = client.execute();
            }
            catch (IOException e) {
                LOG.error(String.format(error, errorArgs), (Object)e.getMessage());
                if (BackOffUtils.next((Sleeper)sleeper, (BackOff)backOff)) continue;
                LOG.error(String.format(error, errorArgs), (Object)"Failing after retrying 3 times.");
                throw e;
            }
            break;
        }
        return (T)result;
    }

    private void readNext() throws IOException, InterruptedException {
        if (this.query != null && this.ref == null) {
            this.ref = this.executeQueryAndWaitForCompletion();
        }
        if (!this.isOpen()) {
            this.open();
        }
        Bigquery.Tabledata.List list = this.client.tabledata().list(this.ref.getProjectId(), this.ref.getDatasetId(), this.ref.getTableId());
        if (this.pageToken != null) {
            list.setPageToken(this.pageToken);
        }
        TableDataList result = (TableDataList)BigQueryTableRowIterator.executeWithBackOff(list, "Error reading from BigQuery table %s of dataset %s : {}", new Object[]{this.ref.getTableId(), this.ref.getDatasetId()});
        this.pageToken = result.getPageToken();
        Iterator<Object> iterator = this.rowIterator = result.getRows() != null ? result.getRows().iterator() : Collections.emptyIterator();
        if (this.pageToken == null || result.getTotalRows() != null && result.getTotalRows() == 0L) {
            this.lastPage = true;
        }
    }

    @Override
    public void close() throws IOException {
        this.lastPage = true;
        try {
            if (this.temporaryDatasetId != null) {
                this.deleteTable(this.temporaryDatasetId, this.temporaryTableId);
                this.deleteDataset(this.temporaryDatasetId);
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private boolean isOpen() {
        return this.schema != null;
    }

    private void open() throws IOException, InterruptedException {
        Bigquery.Tables.Get get = this.client.tables().get(this.ref.getProjectId(), this.ref.getDatasetId(), this.ref.getTableId());
        Table table = (Table)BigQueryTableRowIterator.executeWithBackOff(get, "Error opening BigQuery table  %s of dataset %s  : {}", new Object[]{this.ref.getTableId(), this.ref.getDatasetId()});
        this.schema = table.getSchema();
    }
}

