/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.services.dataflow.model.Source;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.runners.worker.ReaderFactory;
import com.google.cloud.dataflow.sdk.util.ReaderUtils;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CloudSourceUtils {
    public static Source flattenBaseSpecs(Source source) {
        if (source.getBaseSpecs() == null) {
            return source;
        }
        HashMap params = new HashMap();
        for (Map baseSpec : source.getBaseSpecs()) {
            params.putAll(baseSpec);
        }
        params.putAll(source.getSpec());
        Source result = source.clone();
        result.setSpec(params);
        result.setBaseSpecs(null);
        return result;
    }

    public static <T> List<T> readElemsFromSource(PipelineOptions options, Source source) {
        try {
            Reader<?> reader = ReaderFactory.Registry.defaultRegistry().create(source, options, null, null, null);
            return ReaderUtils.readElemsFromReader(reader);
        }
        catch (Exception e) {
            String string = String.valueOf(source.toString());
            throw new RuntimeException(string.length() != 0 ? "Failed to read from source: ".concat(string) : new String("Failed to read from source: "), e);
        }
    }
}

