/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.util.IOChannelFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIOChannelFactory
implements IOChannelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FileIOChannelFactory.class);

    @Override
    public Collection<String> match(String spec) throws IOException {
        File file = new File(spec);
        File parent = file.getAbsoluteFile().getParentFile();
        if (!parent.exists()) {
            String string = String.valueOf(spec);
            throw new IOException(string.length() != 0 ? "Unable to find parent directory of ".concat(string) : new String("Unable to find parent directory of "));
        }
        String pathToMatch = file.getAbsolutePath().replaceAll(Matcher.quoteReplacement("\\"), Matcher.quoteReplacement("\\\\"));
        String string = String.valueOf(pathToMatch);
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher(string.length() != 0 ? "glob:".concat(string) : new String("glob:"));
        File[] files = parent.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return matcher.matches(pathname.toPath());
            }
        });
        LinkedList<String> result = new LinkedList<String>();
        for (File match : files) {
            result.add(match.getPath());
        }
        return result;
    }

    @Override
    public ReadableByteChannel open(String spec) throws IOException {
        LOG.debug("opening file {}", (Object)spec);
        FileInputStream inputStream = new FileInputStream(spec);
        return inputStream.getChannel();
    }

    @Override
    public WritableByteChannel create(String spec, String mimeType) throws IOException {
        LOG.debug("creating file {}", (Object)spec);
        File file = new File(spec);
        if (file.getAbsoluteFile().getParentFile() != null && !file.getAbsoluteFile().getParentFile().exists() && !file.getAbsoluteFile().getParentFile().mkdirs()) {
            throw new IOException(new StringBuilder(42 + String.valueOf(spec).length()).append("Unable to create parent directories for '").append(spec).append("'").toString());
        }
        return Channels.newChannel(new BufferedOutputStream(new FileOutputStream(file)));
    }

    @Override
    public long getSizeBytes(String spec) throws IOException {
        try {
            return Files.size(FileSystems.getDefault().getPath(spec, new String[0]));
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getReason());
        }
    }

    @Override
    public boolean isReadSeekEfficient(String spec) throws IOException {
        return true;
    }

    @Override
    public String resolve(String path, String other) throws IOException {
        return Paths.get(path, new String[0]).resolve(other).toString();
    }
}

