/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.options.GcsOptions;
import com.google.cloud.dataflow.sdk.util.GcsUtil;
import com.google.cloud.dataflow.sdk.util.IOChannelFactory;
import com.google.cloud.dataflow.sdk.util.gcsfs.GcsPath;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class GcsIOChannelFactory
implements IOChannelFactory {
    private final GcsOptions options;

    public GcsIOChannelFactory(GcsOptions options) {
        this.options = options;
    }

    @Override
    public Collection<String> match(String spec) throws IOException {
        GcsPath path = GcsPath.fromUri(spec);
        GcsUtil util = this.options.getGcsUtil();
        List<GcsPath> matched = util.expand(path);
        LinkedList<String> specs = new LinkedList<String>();
        for (GcsPath match : matched) {
            specs.add(match.toString());
        }
        return specs;
    }

    @Override
    public ReadableByteChannel open(String spec) throws IOException {
        GcsPath path = GcsPath.fromUri(spec);
        GcsUtil util = this.options.getGcsUtil();
        return util.open(path);
    }

    @Override
    public WritableByteChannel create(String spec, String mimeType) throws IOException {
        GcsPath path = GcsPath.fromUri(spec);
        GcsUtil util = this.options.getGcsUtil();
        return util.create(path, mimeType);
    }

    @Override
    public long getSizeBytes(String spec) throws IOException {
        GcsPath path = GcsPath.fromUri(spec);
        GcsUtil util = this.options.getGcsUtil();
        return util.fileSize(path);
    }

    @Override
    public boolean isReadSeekEfficient(String spec) throws IOException {
        return true;
    }

    @Override
    public String resolve(String path, String other) throws IOException {
        return GcsPath.fromUri(path).resolve(other).toString();
    }
}

