/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.dataflow.sdk.options.DefaultValueFactory;
import com.google.cloud.dataflow.sdk.options.GcsOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.util.AttemptBoundedExponentialBackOff;
import com.google.cloud.dataflow.sdk.util.Transport;
import com.google.cloud.dataflow.sdk.util.gcsfs.GcsPath;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageWriteChannel;
import com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.util.RetryDeterminer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GcsUtil.class);
    private static final long MAX_LIST_ITEMS_PER_CALL = 1024L;
    private static final Pattern GLOB_PREFIX = Pattern.compile("(?<PREFIX>[^\\[*?]*)[\\[*?].*");
    private static final String RECURSIVE_WILDCARD = "[*]{2}";
    private static final Pattern RECURSIVE_GCS_PATTERN = Pattern.compile(".*[*]{2}.*");
    private Storage storage;
    private final ApiErrorExtractor errorExtractor = new ApiErrorExtractor();
    final ExecutorService executorService;

    public boolean isGcsPatternSupported(String gcsPattern) {
        if (RECURSIVE_GCS_PATTERN.matcher(gcsPattern).matches()) {
            throw new IllegalArgumentException(new StringBuilder(73 + String.valueOf(gcsPattern).length()).append("Unsupported wildcard usage in \"").append(gcsPattern).append("\": ").append(" recursive wildcards are not supported.").toString());
        }
        return true;
    }

    private GcsUtil(Storage storageClient, ExecutorService executorService) {
        this.storage = storageClient;
        this.executorService = executorService;
    }

    protected void setStorageClient(Storage storage) {
        this.storage = storage;
    }

    public List<GcsPath> expand(GcsPath gcsPattern) throws IOException {
        Objects objects;
        Preconditions.checkArgument(this.isGcsPatternSupported(gcsPattern.getObject()));
        Matcher m = GLOB_PREFIX.matcher(gcsPattern.getObject());
        Pattern p = null;
        String prefix = null;
        if (!m.matches()) {
            return ImmutableList.of(gcsPattern);
        }
        prefix = m.group("PREFIX");
        p = Pattern.compile(GcsUtil.globToRegexp(gcsPattern.getObject()));
        LOG.debug("matching files in bucket {}, prefix {} against pattern {}", new Object[]{gcsPattern.getBucket(), prefix, p.toString()});
        Storage.Objects.List listObject = this.storage.objects().list(gcsPattern.getBucket());
        listObject.setMaxResults(Long.valueOf(1024L));
        listObject.setPrefix(prefix);
        String pageToken = null;
        LinkedList<GcsPath> results = new LinkedList<GcsPath>();
        do {
            if (pageToken != null) {
                listObject.setPageToken(pageToken);
            }
            try {
                objects = (Objects)ResilientOperation.retry((ResilientOperation.CheckedCallable)ResilientOperation.getGoogleRequestCallable((AbstractGoogleClientRequest)listObject), (BackOff)new AttemptBoundedExponentialBackOff(3, 200L), (RetryDeterminer)RetryDeterminer.SOCKET_ERRORS, IOException.class);
            }
            catch (Exception e) {
                String string = gcsPattern.getBucket();
                String string2 = prefix;
                String string3 = String.valueOf(p.toString());
                throw new IOException(new StringBuilder(58 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unable to match files in bucket ").append(string).append(", prefix ").append(string2).append(" against pattern ").append(string3).toString(), e);
            }
            Preconditions.checkNotNull(objects);
            if (objects.getItems() == null) break;
            for (StorageObject o : objects.getItems()) {
                String name = o.getName();
                if (!p.matcher(name).matches() || name.endsWith("/")) continue;
                LOG.debug("Matched object: {}", (Object)name);
                results.add(GcsPath.fromObject(o));
            }
        } while ((pageToken = objects.getNextPageToken()) != null);
        return results;
    }

    public long fileSize(GcsPath path) throws IOException {
        return this.fileSize(path, new AttemptBoundedExponentialBackOff(4, 200L), Sleeper.DEFAULT);
    }

    @VisibleForTesting
    long fileSize(GcsPath path, BackOff backoff, Sleeper sleeper) throws IOException {
        Storage.Objects.Get getObject = this.storage.objects().get(path.getBucket(), path.getObject());
        try {
            StorageObject object = (StorageObject)ResilientOperation.retry((ResilientOperation.CheckedCallable)ResilientOperation.getGoogleRequestCallable((AbstractGoogleClientRequest)getObject), (BackOff)backoff, (RetryDeterminer)RetryDeterminer.SOCKET_ERRORS, IOException.class, (Sleeper)sleeper);
            return object.getSize().longValue();
        }
        catch (Exception e) {
            if (e instanceof IOException && this.errorExtractor.itemNotFound((IOException)e)) {
                throw new FileNotFoundException(path.toString());
            }
            throw new IOException("Unable to get file size", e);
        }
    }

    public SeekableByteChannel open(GcsPath path) throws IOException {
        return new GoogleCloudStorageReadChannel(this.storage, path.getBucket(), path.getObject(), this.errorExtractor, new ClientRequestHelper());
    }

    public WritableByteChannel create(GcsPath path, String type) throws IOException {
        GoogleCloudStorageWriteChannel channel = new GoogleCloudStorageWriteChannel(this.executorService, this.storage, new ClientRequestHelper(), path.getBucket(), path.getObject(), new AsyncWriteChannelOptions.Builder().build(), new ObjectWriteConditions(), Collections.emptyMap(), type);
        channel.initialize();
        return channel;
    }

    public boolean bucketExists(GcsPath path) throws IOException {
        return this.bucketExists(path, new AttemptBoundedExponentialBackOff(4, 200L), Sleeper.DEFAULT);
    }

    @VisibleForTesting
    boolean bucketExists(GcsPath path, BackOff backoff, Sleeper sleeper) throws IOException {
        Storage.Buckets.Get getBucket = this.storage.buckets().get(path.getBucket());
        try {
            ResilientOperation.retry((ResilientOperation.CheckedCallable)ResilientOperation.getGoogleRequestCallable((AbstractGoogleClientRequest)getBucket), (BackOff)backoff, (RetryDeterminer)new RetryDeterminer<IOException>(){

                public boolean shouldRetry(IOException e) {
                    if (GcsUtil.this.errorExtractor.itemNotFound(e) || GcsUtil.this.errorExtractor.accessDenied(e)) {
                        return false;
                    }
                    return RetryDeterminer.SOCKET_ERRORS.shouldRetry((Exception)e);
                }
            }, IOException.class, (Sleeper)sleeper);
            return true;
        }
        catch (GoogleJsonResponseException e) {
            if (this.errorExtractor.itemNotFound((IOException)((Object)e)) || this.errorExtractor.accessDenied((IOException)((Object)e))) {
                return false;
            }
            throw e;
        }
        catch (InterruptedException e) {
            throw new IOException(String.format("Error while attempting to verify existence of bucket gs://%s", path.getBucket()), e);
        }
    }

    static String globToRegexp(String globExp) {
        StringBuilder dst = new StringBuilder();
        char[] src = globExp.toCharArray();
        int i = 0;
        block6: while (i < src.length) {
            char c = src[i++];
            switch (c) {
                case '*': {
                    dst.append("[^/]*");
                    continue block6;
                }
                case '?': {
                    dst.append("[^/]");
                    continue block6;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    dst.append('\\').append(c);
                    continue block6;
                }
                case '\\': {
                    i = GcsUtil.doubleSlashes(dst, src, i);
                    continue block6;
                }
            }
            dst.append(c);
        }
        return dst.toString();
    }

    private static int doubleSlashes(StringBuilder dst, char[] src, int i) {
        dst.append('\\');
        if (i - 1 != src.length) {
            dst.append(src[i]);
            ++i;
        } else {
            dst.append('\\');
        }
        return i;
    }

    public static class GcsUtilFactory
    implements DefaultValueFactory<GcsUtil> {
        @Override
        public GcsUtil create(PipelineOptions options) {
            GcsOptions gcsOptions = options.as(GcsOptions.class);
            LOG.debug("Creating new GcsUtil");
            return new GcsUtil(Transport.newStorageClient(gcsOptions).build(), gcsOptions.getExecutorService());
        }
    }
}

