/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.IterableCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Function;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.HashMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.InvalidWindows;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.PValueBase;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class PCollectionViews {
    public static <T, W extends BoundedWindow> PCollectionView<T> singletonView(Pipeline pipeline, WindowingStrategy<?, W> windowingStrategy, boolean hasDefault, T defaultValue, Coder<T> valueCoder) {
        return new SingletonPCollectionView<T, W>(pipeline, windowingStrategy, hasDefault, defaultValue, valueCoder);
    }

    public static <T, W extends BoundedWindow> PCollectionView<Iterable<T>> iterableView(Pipeline pipeline, WindowingStrategy<?, W> windowingStrategy, Coder<T> valueCoder) {
        return new IterablePCollectionView<T, W>(pipeline, windowingStrategy, valueCoder);
    }

    public static <K, V, W extends BoundedWindow> PCollectionView<Map<K, V>> mapView(Pipeline pipeline, WindowingStrategy<?, W> windowingStrategy, Coder<KV<K, V>> valueCoder) {
        return new MapPCollectionView<K, V, W>(pipeline, windowingStrategy, valueCoder);
    }

    public static <K, V, W extends BoundedWindow> PCollectionView<Map<K, Iterable<V>>> multimapView(Pipeline pipeline, WindowingStrategy<?, W> windowingStrategy, Coder<KV<K, V>> valueCoder) {
        return new MultimapPCollectionView<K, V, W>(pipeline, windowingStrategy, valueCoder);
    }

    private static abstract class PCollectionViewBase<ElemT, ViewT, W extends BoundedWindow>
    extends PValueBase
    implements PCollectionView<ViewT> {
        private TupleTag<Iterable<WindowedValue<ElemT>>> tag;
        private WindowingStrategy<?, W> windowingStrategy;
        private Coder<Iterable<WindowedValue<ElemT>>> coder;

        protected abstract ViewT fromElements(Iterable<WindowedValue<ElemT>> var1);

        protected PCollectionViewBase(Pipeline pipeline, TupleTag<Iterable<WindowedValue<ElemT>>> tag, WindowingStrategy<?, W> windowingStrategy, Coder<ElemT> valueCoder) {
            super(pipeline);
            if (windowingStrategy.getWindowFn() instanceof InvalidWindows) {
                throw new IllegalArgumentException("WindowFn of PCollectionView cannot be InvalidWindows");
            }
            this.tag = tag;
            this.windowingStrategy = windowingStrategy;
            this.coder = IterableCoder.of(WindowedValue.getFullCoder(valueCoder, windowingStrategy.getWindowFn().windowCoder()));
        }

        protected PCollectionViewBase(Pipeline pipeline, WindowingStrategy<?, W> windowingStrategy, Coder<ElemT> valueCoder) {
            this(pipeline, new TupleTag<Iterable<WindowedValue<ElemT>>>(), windowingStrategy, valueCoder);
        }

        protected PCollectionViewBase() {
        }

        @Override
        public ViewT fromIterableInternal(Iterable<WindowedValue<?>> elements) {
            Iterable<WindowedValue<ElemT>> typedElements = elements;
            return this.fromElements(typedElements);
        }

        @Override
        public TupleTag<Iterable<WindowedValue<?>>> getTagInternal() {
            TupleTag<Iterable<WindowedValue<?>>> untypedTag = this.tag;
            return untypedTag;
        }

        @Override
        public WindowingStrategy<?, ?> getWindowingStrategyInternal() {
            return this.windowingStrategy;
        }

        @Override
        public Coder<Iterable<WindowedValue<?>>> getCoderInternal() {
            Coder<Iterable<WindowedValue<?>>> untypedCoder = this.coder;
            return untypedCoder;
        }

        public int hashCode() {
            return Objects.hash(this.tag);
        }

        public boolean equals(Object other) {
            if (!(other instanceof PCollectionView) || other == null) {
                return false;
            }
            PCollectionView otherView = (PCollectionView)other;
            return this.tag.equals(otherView.getTagInternal());
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("tag", this.tag).toString();
        }
    }

    private static class MapPCollectionView<K, V, W extends BoundedWindow>
    extends PCollectionViewBase<KV<K, V>, Map<K, V>, W> {
        public MapPCollectionView(Pipeline pipeline, WindowingStrategy<KV<K, V>, W> windowingStrategy, Coder<KV<K, V>> valueCoder) {
            super(pipeline, windowingStrategy, valueCoder);
        }

        @Override
        protected Map<K, V> fromElements(Iterable<WindowedValue<KV<K, V>>> elements) {
            HashMap<K, V> map = new HashMap<K, V>();
            for (WindowedValue<KV<K, V>> elem : elements) {
                KV<K, V> kv = elem.getValue();
                if (map.put(kv.getKey(), kv.getValue()) == null) continue;
                String string = String.valueOf(kv.getKey());
                throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(string).length()).append("Duplicate values for ").append(string).toString());
            }
            return Collections.unmodifiableMap(map);
        }
    }

    private static class MultimapPCollectionView<K, V, W extends BoundedWindow>
    extends PCollectionViewBase<KV<K, V>, Map<K, Iterable<V>>, W> {
        public MultimapPCollectionView(Pipeline pipeline, WindowingStrategy<KV<K, V>, W> windowingStrategy, Coder<KV<K, V>> valueCoder) {
            super(pipeline, windowingStrategy, valueCoder);
        }

        @Override
        protected Map<K, Iterable<V>> fromElements(Iterable<WindowedValue<KV<K, V>>> elements) {
            HashMultimap<K, V> multimap = HashMultimap.create();
            for (WindowedValue<KV<K, V>> elem : elements) {
                KV<K, V> kv = elem.getValue();
                multimap.put(kv.getKey(), kv.getValue());
            }
            Map resultMap = multimap.asMap();
            return resultMap;
        }
    }

    private static class IterablePCollectionView<T, W extends BoundedWindow>
    extends PCollectionViewBase<T, Iterable<T>, W> {
        public IterablePCollectionView(Pipeline pipeline, WindowingStrategy<?, W> windowingStrategy, Coder<T> valueCoder) {
            super(pipeline, windowingStrategy, valueCoder);
        }

        @Override
        protected Iterable<T> fromElements(Iterable<WindowedValue<T>> contents) {
            return Iterables.transform(contents, new Function<WindowedValue<T>, T>(){

                @Override
                public T apply(WindowedValue<T> input) {
                    return input.getValue();
                }
            });
        }
    }

    private static class SingletonPCollectionView<T, W extends BoundedWindow>
    extends PCollectionViewBase<T, T, W> {
        private byte[] encodedDefaultValue;
        private transient T defaultValue;
        private Coder<T> valueCoder;

        public SingletonPCollectionView(Pipeline pipeline, WindowingStrategy<?, W> windowingStrategy, boolean hasDefault, T defaultValue, Coder<T> valueCoder) {
            super(pipeline, windowingStrategy, valueCoder);
            this.defaultValue = defaultValue;
            this.valueCoder = valueCoder;
            if (hasDefault) {
                try {
                    this.encodedDefaultValue = CoderUtils.encodeToByteArray(valueCoder, defaultValue);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected IOException: ", e);
                }
            }
        }

        @Override
        protected T fromElements(Iterable<WindowedValue<T>> contents) {
            if (this.encodedDefaultValue != null && this.defaultValue == null) {
                try {
                    this.defaultValue = CoderUtils.decodeFromByteArray(this.valueCoder, this.encodedDefaultValue);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected IOException: ", e);
                }
            }
            try {
                return Iterables.getOnlyElement(contents).getValue();
            }
            catch (NoSuchElementException exc) {
                if (this.encodedDefaultValue != null) {
                    return this.defaultValue;
                }
                throw new NoSuchElementException("Empty PCollection accessed as a singleton view.");
            }
            catch (IllegalArgumentException exc) {
                throw new IllegalArgumentException("PCollection with more than one element accessed as a singleton view.");
            }
        }
    }
}

