/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.values.TupleTag;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class PTuple {
    private final Map<TupleTag<?>, ?> valueMap;

    public static PTuple empty() {
        return new PTuple();
    }

    public static <V> PTuple of(TupleTag<V> tag, V value) {
        return PTuple.empty().and(tag, value);
    }

    public <V> PTuple and(TupleTag<V> tag, V value) {
        LinkedHashMap<TupleTag<V>, Object> newMap = new LinkedHashMap<TupleTag<V>, Object>();
        newMap.putAll(this.valueMap);
        newMap.put(tag, value);
        return new PTuple(newMap);
    }

    public <V> boolean has(TupleTag<V> tag) {
        return this.valueMap.containsKey(tag);
    }

    public boolean isEmpty() {
        return this.valueMap.isEmpty();
    }

    public <V> V get(TupleTag<V> tag) {
        if (!this.has(tag)) {
            throw new IllegalArgumentException("TupleTag not found in this PTuple");
        }
        Object value = this.valueMap.get(tag);
        return (V)value;
    }

    public Map<TupleTag<?>, ?> getAll() {
        return this.valueMap;
    }

    private PTuple() {
        this(new LinkedHashMap());
    }

    private PTuple(Map<TupleTag<?>, ?> valueMap) {
        this.valueMap = Collections.unmodifiableMap(valueMap);
    }

    public static PTuple ofInternal(Map<TupleTag<?>, ?> valueMap) {
        return new PTuple(valueMap);
    }
}

