/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.PaneInfo;
import com.google.cloud.dataflow.sdk.util.ReduceFn;
import com.google.cloud.dataflow.sdk.util.TimerInternals;
import com.google.cloud.dataflow.sdk.util.state.StateContents;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.StateTags;
import com.google.cloud.dataflow.sdk.util.state.ValueState;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class PaneInfoTracker {
    private TimerInternals timerInternals;
    @VisibleForTesting
    static final StateTag<ValueState<PaneInfo>> PANE_INFO_TAG = StateTags.makeSystemTagInternal(StateTags.value("pane", PaneInfo.PaneInfoCoder.INSTANCE));

    public PaneInfoTracker(TimerInternals timerInternals) {
        this.timerInternals = timerInternals;
    }

    public void clear(ReduceFn.StateContext state) {
        state.access(PANE_INFO_TAG).clear();
    }

    public StateContents<PaneInfo> getNextPaneInfo(ReduceFn.Context context, final boolean isForWatermarkTrigger, final boolean isFinal) {
        final StateContents<PaneInfo> previousPaneFuture = context.state().access(PANE_INFO_TAG).get();
        final Instant endOfWindow = ((BoundedWindow)context.window()).maxTimestamp();
        return new StateContents<PaneInfo>(){

            @Override
            public PaneInfo read() {
                PaneInfo previousPane = (PaneInfo)previousPaneFuture.read();
                return PaneInfoTracker.this.describePane(endOfWindow, previousPane, isForWatermarkTrigger, isFinal);
            }
        };
    }

    public void storeCurrentPaneInfo(ReduceFn.Context context, PaneInfo currentPane) {
        context.state().access(PANE_INFO_TAG).set(currentPane);
    }

    private <W> PaneInfo describePane(Instant endOfWindow, PaneInfo prevPane, boolean isForWatermarkTrigger, boolean isFinal) {
        long nonSpeculativeIndex;
        PaneInfo.Timing timing;
        long index;
        boolean isSpeculative = endOfWindow.isAfter((ReadableInstant)this.timerInternals.currentWatermarkTime());
        boolean isFirst = prevPane == null;
        long l = index = isFirst ? 0L : prevPane.getIndex() + 1L;
        if (isSpeculative) {
            timing = PaneInfo.Timing.EARLY;
            nonSpeculativeIndex = -1L;
        } else {
            boolean firstNonSpeculative = prevPane == null || prevPane.getTiming() == PaneInfo.Timing.EARLY;
            timing = isForWatermarkTrigger && firstNonSpeculative ? PaneInfo.Timing.ON_TIME : PaneInfo.Timing.LATE;
            nonSpeculativeIndex = firstNonSpeculative ? 0L : prevPane.getNonSpeculativeIndex() + 1L;
        }
        return PaneInfo.createPane(isFirst, isFinal, timing, index, nonSpeculativeIndex);
    }
}

