/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.PaneInfo;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.state.MergeableState;
import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.StateContents;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.joda.time.Instant;

public abstract class ReduceFn<K, InputT, OutputT, W extends BoundedWindow>
implements Serializable {
    public abstract void processValue(ProcessValueContext var1) throws Exception;

    public abstract void onMerge(OnMergeContext var1) throws Exception;

    public abstract void onTrigger(OnTriggerContext var1) throws Exception;

    public void prefetchOnTrigger(StateContext c) {
    }

    public abstract void clearState(Context var1) throws Exception;

    public abstract StateContents<Boolean> isEmpty(StateContext var1);

    public abstract class OnTriggerContext
    extends Context {
        public abstract PaneInfo paneInfo();

        public abstract void output(OutputT var1);
    }

    public abstract class OnMergeContext
    extends Context {
        public abstract Collection<W> mergingWindows();

        @Override
        public abstract MergingStateContext state();
    }

    public abstract class ProcessValueContext
    extends Context {
        public abstract InputT value();

        public abstract Instant timestamp();
    }

    public abstract class Context {
        public abstract K key();

        public abstract W window();

        public abstract WindowingStrategy<?, W> windowingStrategy();

        public abstract StateContext state();

        public abstract Timers timers();
    }

    public static interface Timers {
        public void setTimer(Instant var1, TimeDomain var2);

        public void deleteTimer(Instant var1, TimeDomain var2);

        public Instant currentProcessingTime();
    }

    public static interface MergingStateContext
    extends StateContext {
        public <StateT extends MergeableState<?, ?>> StateT accessAcrossMergingWindows(StateTag<StateT> var1);

        public <StateT extends State> Map<BoundedWindow, StateT> accessInEachMergingWindow(StateTag<StateT> var1);
    }

    public static interface StateContext {
        public <StateT extends State> StateT access(StateTag<StateT> var1);

        public <StateT extends MergeableState<?, ?>> StateT accessAcrossMergedWindows(StateTag<StateT> var1);
    }
}

