/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Joiner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final String[] STANDARD_NAME_SUFFIXES = new String[]{"DoFn", "Fn"};
    private static final Pattern NAMED_INNER_CLASS = Pattern.compile(".+\\$(?<INNER>[^0-9].*)");
    private static final String ANONYMOUS_CLASS_REGEX = "\\$[0-9]+\\$";

    public static String byteArrayToJsonString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            char c;
            if (b >= 32 && b < 127 && (c = (char)b) != '%' && c != '\\' && c != '\"') {
                sb.append(c);
                continue;
            }
            sb.append(String.format("%%%02x", b));
        }
        return sb.toString();
    }

    public static byte[] jsonStringToByteArray(String string) {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        int i = 0;
        while (i < string.length()) {
            Byte b;
            char c = string.charAt(i);
            if (c == '%') {
                try {
                    b = (byte)Integer.parseInt(string.substring(i + 1, i + 3), 16);
                }
                catch (IndexOutOfBoundsException | NumberFormatException exn) {
                    String string2 = String.valueOf("not in legal encoded format; substring [");
                    int n = i;
                    int n2 = i + 2;
                    throw new IllegalArgumentException(new StringBuilder(45 + String.valueOf(string2).length()).append(string2).append(n).append("..").append(n2).append("] not in format \"%xx\"").toString(), exn);
                }
                i += 3;
            } else {
                b = (byte)c;
                ++i;
            }
            bytes.add(b);
        }
        byte[] byteArray = new byte[bytes.size()];
        int i2 = 0;
        for (Byte b : bytes) {
            byteArray[i2++] = b;
        }
        return byteArray;
    }

    public static String approximateSimpleName(Class<?> clazz) {
        return StringUtils.approximateSimpleName(clazz, true);
    }

    public static String approximatePTransformName(Class<?> clazz) {
        Preconditions.checkArgument(PTransform.class.isAssignableFrom(clazz));
        return StringUtils.approximateSimpleName(clazz, false).replaceFirst("\\.Bound$", "");
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        Preconditions.checkNotNull(s);
        Preconditions.checkNotNull(t);
        if (s.equals(t)) {
            return 0;
        }
        if (s.length() == 0) {
            return t.length();
        }
        if (t.length() == 0) {
            return s.length();
        }
        int[] v0 = new int[t.length() + 1];
        int[] v1 = new int[t.length() + 1];
        for (i = 0; i < v0.length; ++i) {
            v0[i] = i;
        }
        for (i = 0; i < s.length(); ++i) {
            v1[0] = i + 1;
            for (int j = 0; j < t.length(); ++j) {
                int cost = s.charAt(i) == t.charAt(j) ? 0 : 1;
                v1[j + 1] = Math.min(Math.min(v1[j] + 1, v0[j + 1] + 1), v0[j] + cost);
            }
            System.arraycopy(v1, 0, v0, 0, v0.length);
        }
        return v1[t.length()];
    }

    private static String approximateSimpleName(Class<?> clazz, boolean dropOuterClassNames) {
        Preconditions.checkArgument(!clazz.isAnonymousClass(), "Attempted to get simple name of anonymous class");
        String fullName = clazz.getName();
        String shortName = fullName.substring(fullName.lastIndexOf(46) + 1);
        Object[] names = shortName.split("\\$");
        for (int i = 0; i < names.length; ++i) {
            names[i] = StringUtils.simplifyNameComponent((String)names[i]);
        }
        shortName = Joiner.on('$').join(names);
        if (dropOuterClassNames) {
            Matcher m = NAMED_INNER_CLASS.matcher(shortName);
            if (m.matches()) {
                shortName = m.group("INNER");
            }
        } else {
            shortName = shortName.replaceAll(ANONYMOUS_CLASS_REGEX, ".");
            shortName = shortName.replaceAll("\\$", ".");
        }
        return shortName;
    }

    private static String simplifyNameComponent(String name) {
        for (String suffix : STANDARD_NAME_SUFFIXES) {
            if (!name.endsWith(suffix) || name.length() <= suffix.length()) continue;
            return name.substring(0, name.length() - suffix.length());
        }
        return name;
    }
}

