/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.client.util.Data;
import com.google.cloud.dataflow.sdk.util.CloudKnownType;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class Structs {
    private Structs() {
    }

    public static String getString(Map<String, Object> map, String name) throws Exception {
        return Structs.getValue(map, name, String.class, "a string");
    }

    public static String getString(Map<String, Object> map, String name, @Nullable String defaultValue) throws Exception {
        return Structs.getValue(map, name, String.class, "a string", defaultValue);
    }

    public static byte[] getBytes(Map<String, Object> map, String name) throws Exception {
        byte[] result = Structs.getBytes(map, name, null);
        if (result == null) {
            throw new ParameterNotFoundException(name, map);
        }
        return result;
    }

    @Nullable
    public static byte[] getBytes(Map<String, Object> map, String name, @Nullable byte[] defaultValue) throws Exception {
        String jsonString = Structs.getString(map, name, null);
        if (jsonString == null) {
            return defaultValue;
        }
        return StringUtils.jsonStringToByteArray(jsonString);
    }

    public static Boolean getBoolean(Map<String, Object> map, String name) throws Exception {
        return Structs.getValue(map, name, Boolean.class, "a boolean");
    }

    @Nullable
    public static Boolean getBoolean(Map<String, Object> map, String name, @Nullable Boolean defaultValue) throws Exception {
        return Structs.getValue(map, name, Boolean.class, "a boolean", defaultValue);
    }

    public static Long getLong(Map<String, Object> map, String name) throws Exception {
        return Structs.getValue(map, name, Long.class, "an int");
    }

    @Nullable
    public static Long getLong(Map<String, Object> map, String name, @Nullable Long defaultValue) throws Exception {
        return Structs.getValue(map, name, Long.class, "an int", defaultValue);
    }

    @Nullable
    public static List<String> getStrings(Map<String, Object> map, String name, @Nullable List<String> defaultValue) throws Exception {
        Object value = map.get(name);
        if (value == null) {
            if (map.containsKey(name)) {
                throw new IncorrectTypeException(name, map, "a string or a list");
            }
            return defaultValue;
        }
        if (Data.isNull((Object)value)) {
            return Collections.emptyList();
        }
        String singletonString = Structs.decodeValue(value, String.class);
        if (singletonString != null) {
            return Collections.singletonList(singletonString);
        }
        if (!(value instanceof List)) {
            throw new IncorrectTypeException(name, map, "a string or a list");
        }
        List elements = (List)value;
        ArrayList<String> result = new ArrayList<String>(elements.size());
        for (Object o : elements) {
            String s = Structs.decodeValue(o, String.class);
            if (s == null) {
                throw new IncorrectTypeException(name, map, "a list of strings");
            }
            result.add(s);
        }
        return result;
    }

    public static Map<String, Object> getObject(Map<String, Object> map, String name) throws Exception {
        Map<String, Object> result = Structs.getObject(map, name, null);
        if (result == null) {
            throw new ParameterNotFoundException(name, map);
        }
        return result;
    }

    @Nullable
    public static Map<String, Object> getObject(Map<String, Object> map, String name, @Nullable Map<String, Object> defaultValue) throws Exception {
        Object value = map.get(name);
        if (value == null) {
            if (map.containsKey(name)) {
                throw new IncorrectTypeException(name, map, "an object");
            }
            return defaultValue;
        }
        return Structs.checkObject(value, map, name);
    }

    private static Map<String, Object> checkObject(Object value, Map<String, Object> map, String name) throws Exception {
        if (Data.isNull((Object)value)) {
            return Collections.emptyMap();
        }
        if (!(value instanceof Map)) {
            throw new IncorrectTypeException(name, map, "an object (not a map)");
        }
        Map mapValue = (Map)value;
        if (!mapValue.containsKey("@type")) {
            throw new IncorrectTypeException(name, map, "an object (no \"@type\" field)");
        }
        return mapValue;
    }

    @Nullable
    public static List<Map<String, Object>> getListOfMaps(Map<String, Object> map, String name, @Nullable List<Map<String, Object>> defaultValue) throws Exception {
        Object value = map.get(name);
        if (value == null) {
            if (map.containsKey(name)) {
                throw new IncorrectTypeException(name, map, "a list");
            }
            return defaultValue;
        }
        if (Data.isNull((Object)value)) {
            return Collections.emptyList();
        }
        if (!(value instanceof List)) {
            throw new IncorrectTypeException(name, map, "a list");
        }
        List elements = (List)value;
        for (Object elem : elements) {
            if (elem instanceof Map) continue;
            throw new IncorrectTypeException(name, map, "a list of Map objects");
        }
        List result = elements;
        return result;
    }

    public static Map<String, Object> getDictionary(Map<String, Object> map, String name) throws Exception {
        Object value = map.get(name);
        if (value == null) {
            throw new ParameterNotFoundException(name, map);
        }
        if (Data.isNull((Object)value)) {
            return Collections.emptyMap();
        }
        if (!(value instanceof Map)) {
            throw new IncorrectTypeException(name, map, "a dictionary");
        }
        Map result = (Map)value;
        return result;
    }

    @Nullable
    public static Map<String, Object> getDictionary(Map<String, Object> map, String name, @Nullable Map<String, Object> defaultValue) throws Exception {
        Object value = map.get(name);
        if (value == null) {
            if (map.containsKey(name)) {
                throw new IncorrectTypeException(name, map, "a dictionary");
            }
            return defaultValue;
        }
        if (Data.isNull((Object)value)) {
            return Collections.emptyMap();
        }
        if (!(value instanceof Map)) {
            throw new IncorrectTypeException(name, map, "a dictionary");
        }
        Map result = (Map)value;
        return result;
    }

    public static void addString(Map<String, Object> map, String name, String value) {
        Structs.addObject(map, name, (Map<String, Object>)((Object)CloudObject.forString(value)));
    }

    public static void addBoolean(Map<String, Object> map, String name, boolean value) {
        Structs.addObject(map, name, (Map<String, Object>)((Object)CloudObject.forBoolean(value)));
    }

    public static void addLong(Map<String, Object> map, String name, long value) {
        Structs.addObject(map, name, (Map<String, Object>)((Object)CloudObject.forInteger(value)));
    }

    public static void addObject(Map<String, Object> map, String name, Map<String, Object> value) {
        map.put(name, value);
    }

    public static void addNull(Map<String, Object> map, String name) {
        map.put(name, Data.nullOf(Object.class));
    }

    public static void addLongs(Map<String, Object> map, String name, long ... longs) {
        ArrayList<CloudObject> elements = new ArrayList<CloudObject>(longs.length);
        long[] lArray = longs;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long value = lArray[i];
            elements.add(CloudObject.forInteger(value));
        }
        map.put(name, elements);
    }

    public static void addList(Map<String, Object> map, String name, List<? extends Map<String, Object>> elements) {
        map.put(name, elements);
    }

    public static void addStringList(Map<String, Object> map, String name, List<String> elements) {
        ArrayList<CloudObject> objects = new ArrayList<CloudObject>(elements.size());
        for (String element : elements) {
            objects.add(CloudObject.forString(element));
        }
        Structs.addList(map, name, objects);
    }

    public static <T extends Map<String, Object>> void addList(Map<String, Object> map, String name, T[] elements) {
        map.put(name, Arrays.asList(elements));
    }

    public static void addDictionary(Map<String, Object> map, String name, Map<String, Object> value) {
        map.put(name, value);
    }

    public static void addDouble(Map<String, Object> map, String name, Double value) {
        Structs.addObject(map, name, (Map<String, Object>)((Object)CloudObject.forFloat(value)));
    }

    private static <T> T getValue(Map<String, Object> map, String name, Class<T> clazz, String type) throws Exception {
        T result = Structs.getValue(map, name, clazz, type, null);
        if (result == null) {
            throw new ParameterNotFoundException(name, map);
        }
        return result;
    }

    @Nullable
    private static <T> T getValue(Map<String, Object> map, String name, Class<T> clazz, String type, @Nullable T defaultValue) throws Exception {
        Object value = map.get(name);
        if (value == null) {
            if (map.containsKey(name)) {
                throw new IncorrectTypeException(name, map, type);
            }
            return defaultValue;
        }
        T result = Structs.decodeValue(value, clazz);
        if (result == null) {
            throw new IncorrectTypeException(name, map, type);
        }
        return result;
    }

    @Nullable
    private static <T> T decodeValue(Object value, Class<T> clazz) {
        try {
            if (value.getClass() == clazz) {
                return clazz.cast(value);
            }
            if (!(value instanceof Map)) {
                return null;
            }
            Map map = (Map)value;
            String typeName = (String)map.get("@type");
            if (typeName == null) {
                return null;
            }
            CloudKnownType knownType = CloudKnownType.forUri(typeName);
            if (knownType == null) {
                return null;
            }
            Object scalar = map.get("value");
            if (scalar == null) {
                return null;
            }
            return knownType.parse(scalar, clazz);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private static final class IncorrectTypeException
    extends Exception {
        public IncorrectTypeException(String name, Map<String, Object> map, String type) {
            String string = String.valueOf(map);
            super(new StringBuilder(28 + String.valueOf(name).length() + String.valueOf(string).length() + String.valueOf(type).length()).append("required parameter ").append(name).append(" in ").append(string).append(" not ").append(type).toString());
        }
    }

    private static final class ParameterNotFoundException
    extends Exception {
        public ParameterNotFoundException(String name, Map<String, Object> map) {
            String string = String.valueOf(map);
            super(new StringBuilder(35 + String.valueOf(name).length() + String.valueOf(string).length()).append("didn't find required parameter ").append(name).append(" in ").append(string).toString());
        }
    }
}

