/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.dataflow.Dataflow;
import com.google.api.services.pubsub.Pubsub;
import com.google.api.services.storage.Storage;
import com.google.cloud.dataflow.sdk.options.BigQueryOptions;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.options.GcsOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.util.RetryHttpRequestInitializer;
import com.google.cloud.dataflow.sdk.util.UploadIdResponseInterceptor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;

public class Transport {
    public static HttpTransport getTransport() {
        return SingletonHelper.HTTP_TRANSPORT;
    }

    public static JsonFactory getJsonFactory() {
        return SingletonHelper.JSON_FACTORY;
    }

    private static ApiComponents apiComponentsFromUrl(String urlString) {
        try {
            String string;
            URL url = new URL(urlString);
            String string2 = String.valueOf(url.getProtocol());
            String string3 = String.valueOf(url.getHost());
            if (url.getPort() > 0) {
                int n = url.getPort();
                string = new StringBuilder(12).append(":").append(n).toString();
            } else {
                string = "";
            }
            String string4 = string;
            String rootUrl = new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append("://").append(string3).append(string4).toString();
            return new ApiComponents(rootUrl, url.getPath());
        }
        catch (MalformedURLException e) {
            String string = String.valueOf(urlString);
            throw new RuntimeException(string.length() != 0 ? "Invalid URL: ".concat(string) : new String("Invalid URL: "));
        }
    }

    public static Bigquery.Builder newBigQueryClient(BigQueryOptions options) {
        return new Bigquery.Builder(Transport.getTransport(), Transport.getJsonFactory(), (HttpRequestInitializer)new RetryHttpRequestInitializer((HttpRequestInitializer)options.getGcpCredential(), ImmutableList.of(Integer.valueOf(404)))).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
    }

    public static Pubsub.Builder newPubsubClient(DataflowPipelineOptions options) {
        return new Pubsub.Builder(Transport.getTransport(), Transport.getJsonFactory(), (HttpRequestInitializer)new RetryHttpRequestInitializer((HttpRequestInitializer)options.getGcpCredential(), ImmutableList.of(Integer.valueOf(404)))).setRootUrl(options.getPubsubRootUrl()).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
    }

    public static Dataflow.Builder newDataflowClient(DataflowPipelineOptions options) {
        String servicePath = options.getDataflowEndpoint();
        ApiComponents components = servicePath.contains("://") ? Transport.apiComponentsFromUrl(servicePath) : new ApiComponents(options.getApiRootUrl(), servicePath);
        return new Dataflow.Builder(Transport.getTransport(), Transport.getJsonFactory(), (HttpRequestInitializer)new RetryHttpRequestInitializer((HttpRequestInitializer)options.getGcpCredential(), ImmutableList.of(Integer.valueOf(404)))).setApplicationName(options.getAppName()).setRootUrl(components.rootUrl).setServicePath(components.servicePath).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
    }

    public static Dataflow.Builder newRawDataflowClient(DataflowPipelineOptions options) {
        return Transport.newDataflowClient(options).setHttpRequestInitializer((HttpRequestInitializer)options.getGcpCredential()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
    }

    public static Storage.Builder newStorageClient(GcsOptions options) {
        String servicePath = options.getGcsEndpoint();
        Storage.Builder storageBuilder = new Storage.Builder(Transport.getTransport(), Transport.getJsonFactory(), (HttpRequestInitializer)new RetryHttpRequestInitializer((HttpRequestInitializer)options.getGcpCredential(), ImmutableList.of(Integer.valueOf(404)), new UploadIdResponseInterceptor())).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
        if (servicePath != null) {
            ApiComponents components = Transport.apiComponentsFromUrl(servicePath);
            storageBuilder.setRootUrl(components.rootUrl);
            storageBuilder.setServicePath(components.servicePath);
        }
        return storageBuilder;
    }

    private static class ApiComponents {
        public String rootUrl;
        public String servicePath;

        public ApiComponents(String root, String path) {
            this.rootUrl = root;
            this.servicePath = path;
        }
    }

    private static class SingletonHelper {
        private static final JsonFactory JSON_FACTORY;
        private static final HttpTransport HTTP_TRANSPORT;

        private SingletonHelper() {
        }

        static {
            try {
                JSON_FACTORY = JacksonFactory.getDefaultInstance();
                HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

