/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Predicate;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.FluentIterable;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Maps;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.util.ActiveWindowSet;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import com.google.cloud.dataflow.sdk.util.ReduceFn;
import com.google.cloud.dataflow.sdk.util.ReduceFnContextFactory;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.state.StateInternals;
import com.google.cloud.dataflow.sdk.util.state.StateNamespace;
import com.google.cloud.dataflow.sdk.util.state.StateNamespaces;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import org.joda.time.Instant;

class TriggerContextFactory<W extends BoundedWindow> {
    private final WindowingStrategy<?, W> windowingStrategy;
    private StateInternals stateInternals;
    private ActiveWindowSet<W> activeWindows;

    TriggerContextFactory(WindowingStrategy<?, W> windowingStrategy, StateInternals stateInternals, ActiveWindowSet<W> activeWindows) {
        this.windowingStrategy = windowingStrategy;
        this.stateInternals = stateInternals;
        this.activeWindows = activeWindows;
    }

    public Trigger.TriggerContext base(ReduceFn.Context context, ExecutableTrigger<W> rootTrigger, BitSet finishedSet) {
        return new TriggerContextImpl(this, (BoundedWindow)context.window(), context.timers(), rootTrigger, finishedSet);
    }

    public Trigger.OnElementContext create(ReduceFn.ProcessValueContext context, ExecutableTrigger<W> rootTrigger, BitSet finishedSet) {
        return new OnElementContextImpl(this, (BoundedWindow)context.window(), context.timers(), rootTrigger, finishedSet, context.value(), context.timestamp());
    }

    public Trigger.OnTimerContext create(ReduceFn.Context context, ExecutableTrigger<W> rootTrigger, BitSet finishedSet, Instant timestamp, TimeDomain domain) {
        return new OnTimerContextImpl(this, (BoundedWindow)context.window(), context.timers(), rootTrigger, finishedSet, timestamp, domain);
    }

    public Trigger.OnMergeContext create(ReduceFn.OnMergeContext context, ExecutableTrigger<W> rootTrigger, BitSet finishedSet, Map<W, BitSet> finishedSets) {
        return new OnMergeContextImpl(this, (BoundedWindow)context.window(), context.timers(), rootTrigger, finishedSet, context.mergingWindows(), finishedSets);
    }

    private ReduceFnContextFactory.StateContextImpl<W> triggerState(W window, ExecutableTrigger<W> trigger) {
        return new TriggerStateContextImpl(this, this.activeWindows, this.windowingStrategy.getWindowFn().windowCoder(), this.stateInternals, window, trigger);
    }

    private static class OnMergeContextImpl
    extends Trigger.OnMergeContext {
        private final ReduceFnContextFactory.MergingStateContextImpl<W> state;
        private final ReduceFn.Timers timers;
        private final MergingTriggerInfoImpl triggerInfo;
        final /* synthetic */ TriggerContextFactory this$0;

        private OnMergeContextImpl(W window, ReduceFn.Timers timers, ExecutableTrigger<W> trigger, BitSet finishedSet, Collection<W> mergingWindows, Map<W, BitSet> finishedSets) {
            this.this$0 = var1_1;
            this.state = new ReduceFnContextFactory.MergingStateContextImpl(((TriggerContextFactory)var1_1).triggerState(window, trigger), mergingWindows);
            this.timers = new TriggerTimers((TriggerContextFactory)var1_1, window, timers);
            this.triggerInfo = var1_1.new MergingTriggerInfoImpl(trigger, finishedSet, this, finishedSets);
        }

        @Override
        public Trigger.OnMergeContext forTrigger(ExecutableTrigger<W> trigger) {
            return new OnMergeContextImpl(this.this$0, this.state.window(), this.timers, trigger, this.triggerInfo.finishedSet, this.state.mergingWindows(), this.triggerInfo.finishedSets);
        }

        @Override
        public Iterable<W> oldWindows() {
            return this.state.mergingWindows();
        }

        @Override
        public ReduceFn.MergingStateContext state() {
            return this.state;
        }

        @Override
        public Trigger.MergingTriggerInfo<W> trigger() {
            return this.triggerInfo;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public ReduceFn.Timers timers() {
            return this.timers;
        }
    }

    private static class OnTimerContextImpl
    extends Trigger.OnTimerContext {
        private final ReduceFnContextFactory.StateContextImpl<W> state;
        private final ReduceFn.Timers timers;
        private final TriggerInfoImpl triggerInfo;
        private final Instant timestamp;
        private final TimeDomain domain;
        final /* synthetic */ TriggerContextFactory this$0;

        private OnTimerContextImpl(W window, ReduceFn.Timers timers, ExecutableTrigger<W> trigger, BitSet finishedSet, Instant timestamp, TimeDomain domain) {
            this.this$0 = var1_1;
            this.state = ((TriggerContextFactory)var1_1).triggerState(window, trigger);
            this.timers = new TriggerTimers((TriggerContextFactory)var1_1, window, timers);
            this.triggerInfo = var1_1.new TriggerInfoImpl(trigger, finishedSet, this);
            this.timestamp = timestamp;
            this.domain = domain;
        }

        @Override
        public Trigger.OnTimerContext forTrigger(ExecutableTrigger<W> trigger) {
            return new OnTimerContextImpl(this.this$0, this.state.window(), this.timers, trigger, this.triggerInfo.finishedSet, this.timestamp, this.domain);
        }

        @Override
        public Trigger.TriggerInfo<W> trigger() {
            return this.triggerInfo;
        }

        @Override
        public ReduceFn.StateContext state() {
            return this.state;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public ReduceFn.Timers timers() {
            return this.timers;
        }

        @Override
        public Instant timestamp() {
            return this.timestamp;
        }

        @Override
        public TimeDomain timeDomain() {
            return this.domain;
        }
    }

    private static class OnElementContextImpl
    extends Trigger.OnElementContext {
        private final ReduceFnContextFactory.StateContextImpl<W> state;
        private final ReduceFn.Timers timers;
        private final TriggerInfoImpl triggerInfo;
        private final Object element;
        private final Instant eventTimestamp;
        final /* synthetic */ TriggerContextFactory this$0;

        private OnElementContextImpl(W window, ReduceFn.Timers timers, ExecutableTrigger<W> trigger, BitSet finishedSet, Object element, Instant eventTimestamp) {
            this.this$0 = var1_1;
            this.state = ((TriggerContextFactory)var1_1).triggerState(window, trigger);
            this.timers = new TriggerTimers((TriggerContextFactory)var1_1, window, timers);
            this.triggerInfo = var1_1.new TriggerInfoImpl(trigger, finishedSet, this);
            this.element = element;
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public Object element() {
            return this.element;
        }

        @Override
        public Instant eventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        public Trigger.OnElementContext forTrigger(ExecutableTrigger<W> trigger) {
            return new OnElementContextImpl(this.this$0, this.state.window(), this.timers, trigger, this.triggerInfo.finishedSet, this.element, this.eventTimestamp);
        }

        @Override
        public Trigger.TriggerInfo<W> trigger() {
            return this.triggerInfo;
        }

        @Override
        public ReduceFn.StateContext state() {
            return this.state;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public ReduceFn.Timers timers() {
            return this.timers;
        }
    }

    private static class TriggerContextImpl
    extends Trigger.TriggerContext {
        private final ReduceFnContextFactory.StateContextImpl<W> state;
        private final ReduceFn.Timers timers;
        private final TriggerInfoImpl triggerInfo;
        final /* synthetic */ TriggerContextFactory this$0;

        private TriggerContextImpl(W window, ReduceFn.Timers timers, ExecutableTrigger<W> trigger, BitSet finishedSet) {
            this.this$0 = var1_1;
            this.state = ((TriggerContextFactory)var1_1).triggerState(window, trigger);
            this.timers = new TriggerTimers((TriggerContextFactory)var1_1, window, timers);
            this.triggerInfo = var1_1.new TriggerInfoImpl(trigger, finishedSet, this);
        }

        @Override
        public Trigger.TriggerContext forTrigger(ExecutableTrigger<W> trigger) {
            return new TriggerContextImpl(this.this$0, this.state.window(), this.timers, trigger, this.triggerInfo.finishedSet);
        }

        @Override
        public Trigger.TriggerInfo<W> trigger() {
            return this.triggerInfo;
        }

        @Override
        public ReduceFn.StateContext state() {
            return this.state;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public ReduceFn.Timers timers() {
            return this.timers;
        }
    }

    private static class TriggerStateContextImpl<W extends BoundedWindow>
    extends ReduceFnContextFactory.StateContextImpl<W> {
        private int triggerIndex;
        final /* synthetic */ TriggerContextFactory this$0;

        public TriggerStateContextImpl(ActiveWindowSet<W> activeWindows, Coder<W> windowCoder, StateInternals stateInternals, W window, ExecutableTrigger<W> trigger) {
            this.this$0 = var1_1;
            super(activeWindows, windowCoder, stateInternals, window);
            this.triggerIndex = trigger.getTriggerIndex();
            this.namespace = this.namespaceFor(window);
        }

        @Override
        protected StateNamespace namespaceFor(W window) {
            return StateNamespaces.windowAndTrigger(this.windowCoder, window, this.triggerIndex);
        }
    }

    private class MergingTriggerInfoImpl
    extends TriggerInfoImpl
    implements Trigger.MergingTriggerInfo<W> {
        private final Map<W, BitSet> finishedSets;

        public MergingTriggerInfoImpl(ExecutableTrigger<W> trigger, BitSet finishedSet, Trigger.TriggerContext context, Map<W, BitSet> finishedSets) {
            super(trigger, finishedSet, context);
            this.finishedSets = finishedSets;
        }

        @Override
        public boolean finishedInAnyMergingWindow() {
            for (BitSet bitSet : this.finishedSets.values()) {
                if (!bitSet.get(this.trigger.getTriggerIndex())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterable<W> getFinishedMergingWindows() {
            return Maps.filterValues(this.finishedSets, new Predicate<BitSet>(){

                @Override
                public boolean apply(BitSet input) {
                    return input.get(MergingTriggerInfoImpl.this.trigger.getTriggerIndex());
                }
            }).keySet();
        }
    }

    private static class TriggerTimers
    implements ReduceFn.Timers {
        private final ReduceFn.Timers timers;
        private final W window;
        final /* synthetic */ TriggerContextFactory this$0;

        public TriggerTimers(W window, ReduceFn.Timers timers) {
            this.this$0 = var1_1;
            this.timers = timers;
            this.window = window;
        }

        @Override
        public void setTimer(Instant timestamp, TimeDomain timeDomain) {
            this.timers.setTimer(timestamp, timeDomain);
        }

        @Override
        public void deleteTimer(Instant timestamp, TimeDomain timeDomain) {
            if (timeDomain == TimeDomain.EVENT_TIME && timestamp.equals((Object)((BoundedWindow)this.window).maxTimestamp())) {
                return;
            }
            this.timers.deleteTimer(timestamp, timeDomain);
        }

        @Override
        public Instant currentProcessingTime() {
            return this.timers.currentProcessingTime();
        }
    }

    private class TriggerInfoImpl
    implements Trigger.TriggerInfo<W> {
        protected final ExecutableTrigger<W> trigger;
        protected final BitSet finishedSet;
        private final Trigger.TriggerContext context;

        public TriggerInfoImpl(ExecutableTrigger<W> trigger, BitSet finishedSet, Trigger.TriggerContext context) {
            this.trigger = trigger;
            this.finishedSet = finishedSet;
            this.context = context;
        }

        @Override
        public boolean isMerging() {
            return !TriggerContextFactory.this.windowingStrategy.getWindowFn().isNonMerging();
        }

        @Override
        public Iterable<ExecutableTrigger<W>> subTriggers() {
            return this.trigger.subTriggers();
        }

        @Override
        public ExecutableTrigger<W> subTrigger(int subtriggerIndex) {
            return this.trigger.subTriggers().get(subtriggerIndex);
        }

        @Override
        public boolean isFinished() {
            return this.finishedSet.get(this.trigger.getTriggerIndex());
        }

        @Override
        public boolean areAllSubtriggersFinished() {
            return Iterables.isEmpty(this.unfinishedSubTriggers());
        }

        @Override
        public Iterable<ExecutableTrigger<W>> unfinishedSubTriggers() {
            return FluentIterable.from(this.trigger.subTriggers()).filter(new Predicate<ExecutableTrigger<W>>(){

                @Override
                public boolean apply(ExecutableTrigger<W> input) {
                    return !TriggerInfoImpl.this.finishedSet.get(input.getTriggerIndex());
                }
            });
        }

        @Override
        public ExecutableTrigger<W> firstUnfinishedSubTrigger() {
            for (ExecutableTrigger subTrigger : this.trigger.subTriggers()) {
                if (this.finishedSet.get(subTrigger.getTriggerIndex())) continue;
                return subTrigger;
            }
            return null;
        }

        @Override
        public void resetTree() throws Exception {
            this.finishedSet.clear(this.trigger.getTriggerIndex(), this.trigger.getFirstIndexAfterSubtree());
            this.trigger.invokeClear(this.context);
        }

        @Override
        public void setFinished(boolean finished) {
            this.finishedSet.set(this.trigger.getTriggerIndex(), finished);
        }
    }
}

