/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.ByteArrayCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.values.PCollection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ValueWithRecordId<ValueT> {
    private final ValueT value;
    private final byte[] id;

    public ValueWithRecordId(ValueT value, byte[] id) {
        this.value = value;
        this.id = id;
    }

    public ValueT getValue() {
        return this.value;
    }

    public byte[] getId() {
        return this.id;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("value", this.value).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValueWithRecordId)) {
            return false;
        }
        ValueWithRecordId otherRecord = (ValueWithRecordId)other;
        return Objects.deepEquals(this.id, otherRecord.id) && Objects.deepEquals(this.value, otherRecord.value);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.id), this.value);
    }

    public static <T> PTransform<PCollection<? extends ValueWithRecordId<T>>, PCollection<T>> stripIds() {
        return ParDo.named("StripIds").of(new DoFn<ValueWithRecordId<T>, T>(){

            @Override
            public void processElement(DoFn.ProcessContext c) {
                c.output(((ValueWithRecordId)c.element()).getValue());
            }
        });
    }

    public static class ValueWithRecordIdCoder<ValueT>
    extends StandardCoder<ValueWithRecordId<ValueT>> {
        Coder<ValueT> valueCoder;
        ByteArrayCoder idCoder;

        public static <ValueT> ValueWithRecordIdCoder<ValueT> of(Coder<ValueT> valueCoder) {
            return new ValueWithRecordIdCoder<ValueT>(valueCoder);
        }

        @JsonCreator
        public static <ValueT> ValueWithRecordIdCoder<ValueT> of(@JsonProperty(value="component_encodings") List<Coder<ValueT>> components) {
            int n = components.size();
            Preconditions.checkArgument(components.size() == 1, new StringBuilder(38).append("Expecting 1 component, got ").append(n).toString());
            return ValueWithRecordIdCoder.of(components.get(0));
        }

        protected ValueWithRecordIdCoder(Coder<ValueT> valueCoder) {
            this.valueCoder = valueCoder;
            this.idCoder = ByteArrayCoder.of();
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.valueCoder);
        }

        @Override
        public void encode(ValueWithRecordId<ValueT> value, OutputStream outStream, Coder.Context context) throws IOException {
            this.valueCoder.encode(((ValueWithRecordId)value).value, outStream, context.nested());
            this.idCoder.encode(((ValueWithRecordId)value).id, outStream, context);
        }

        @Override
        public ValueWithRecordId<ValueT> decode(InputStream inStream, Coder.Context context) throws IOException {
            return new ValueWithRecordId<ValueT>(this.valueCoder.decode(inStream, context.nested()), this.idCoder.decode(inStream, context));
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.valueCoder.verifyDeterministic();
        }

        public Coder<ValueT> getValueCoder() {
            return this.valueCoder;
        }
    }
}

