/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.DefaultTrigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindows;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.Window;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import com.google.cloud.dataflow.sdk.util.StringUtils;
import java.io.Serializable;
import org.joda.time.Duration;

public class WindowingStrategy<T, W extends BoundedWindow>
implements Serializable {
    private static final Duration DEFAULT_ALLOWED_LATENESS = Duration.ZERO;
    private static final WindowingStrategy<Object, GlobalWindow> DEFAULT = WindowingStrategy.of(new GlobalWindows());
    private final WindowFn<T, W> windowFn;
    private final ExecutableTrigger<W> trigger;
    private final AccumulationMode mode;
    private final Duration allowedLateness;
    private final Window.ClosingBehavior closingBehavior;
    private final boolean triggerSpecified;
    private final boolean modeSpecified;
    private final boolean allowedLatenessSpecified;

    private WindowingStrategy(WindowFn<T, W> windowFn, ExecutableTrigger<W> trigger, boolean triggerSpecified, AccumulationMode mode, boolean modeSpecified, Duration allowedLateness, boolean allowedLatenessSpecified, Window.ClosingBehavior closingBehavior) {
        this.windowFn = windowFn;
        this.trigger = trigger;
        this.triggerSpecified = triggerSpecified;
        this.mode = mode;
        this.modeSpecified = modeSpecified;
        this.allowedLateness = allowedLateness;
        this.allowedLatenessSpecified = allowedLatenessSpecified;
        this.closingBehavior = closingBehavior;
    }

    public static WindowingStrategy<Object, GlobalWindow> globalDefault() {
        return DEFAULT;
    }

    public static <T, W extends BoundedWindow> WindowingStrategy<T, W> of(WindowFn<T, W> windowFn) {
        return new WindowingStrategy<T, W>(windowFn, ExecutableTrigger.create(DefaultTrigger.of()), false, AccumulationMode.DISCARDING_FIRED_PANES, false, DEFAULT_ALLOWED_LATENESS, false, Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
    }

    public WindowFn<T, W> getWindowFn() {
        return this.windowFn;
    }

    public ExecutableTrigger<W> getTrigger() {
        return this.trigger;
    }

    public boolean isTriggerSpecified() {
        return this.triggerSpecified;
    }

    public Duration getAllowedLateness() {
        return this.allowedLateness;
    }

    public boolean isAllowedLatenessSpecified() {
        return this.allowedLatenessSpecified;
    }

    public AccumulationMode getMode() {
        return this.mode;
    }

    public boolean isModeSpecified() {
        return this.modeSpecified;
    }

    public Window.ClosingBehavior getClosingBehavior() {
        return this.closingBehavior;
    }

    public WindowingStrategy<T, W> withTrigger(Trigger<?> wildcardTrigger) {
        Trigger<?> typedTrigger = wildcardTrigger;
        return new WindowingStrategy<T, W>(this.windowFn, ExecutableTrigger.create(typedTrigger), true, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.closingBehavior);
    }

    public WindowingStrategy<T, W> withMode(AccumulationMode mode) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, mode, true, this.allowedLateness, this.allowedLatenessSpecified, this.closingBehavior);
    }

    public WindowingStrategy<T, W> withWindowFn(WindowFn<?, ?> wildcardWindowFn) {
        WindowFn<?, ?> typedWindowFn = wildcardWindowFn;
        return new WindowingStrategy(typedWindowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.closingBehavior);
    }

    public WindowingStrategy<T, W> withAllowedLateness(Duration allowedLateness) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, allowedLateness, true, this.closingBehavior);
    }

    public WindowingStrategy<T, W> withClosingBehavior(Window.ClosingBehavior closingBehavior) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, closingBehavior);
    }

    public String toString() {
        return String.format("%s, %s, %s", StringUtils.approximateSimpleName(this.windowFn.getClass()), this.trigger.toString(), this.mode.toString());
    }

    public static enum AccumulationMode {
        DISCARDING_FIRED_PANES,
        ACCUMULATING_FIRED_PANES;

    }
}

