/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Objects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Throwables;
import com.google.cloud.dataflow.sdk.util.common.worker.ShuffleBatchReader;
import com.google.cloud.dataflow.sdk.util.common.worker.ShufflePosition;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import javax.annotation.Nullable;

public final class CachingShuffleBatchReader
implements ShuffleBatchReader {
    private final ShuffleBatchReader reader;
    final HashMap<BatchRange, RangeReadReference> cache = new HashMap();
    private final ReferenceQueue<AsyncReadResult> refQueue = new ReferenceQueue();

    public CachingShuffleBatchReader(ShuffleBatchReader reader) {
        this.reader = Preconditions.checkNotNull(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShuffleBatchReader.Batch read(@Nullable ShufflePosition startPosition, @Nullable ShufflePosition endPosition) throws IOException {
        AsyncReadResult waitResult = null;
        AsyncReadResult runResult = null;
        BatchRange batchRange = new BatchRange(startPosition, endPosition);
        HashMap<BatchRange, RangeReadReference> hashMap = this.cache;
        synchronized (hashMap) {
            Reference<AsyncReadResult> ref = this.refQueue.poll();
            while (ref != null) {
                RangeReadReference rangeReadRef = (RangeReadReference)ref;
                this.cache.remove(rangeReadRef.getBatchRange());
                ref = this.refQueue.poll();
            }
            RangeReadReference rangeReadRef = this.cache.get(batchRange);
            if (rangeReadRef != null) {
                waitResult = (AsyncReadResult)rangeReadRef.get();
            }
            if (waitResult == null) {
                waitResult = runResult = new AsyncReadResult();
                rangeReadRef = null;
            }
            if (rangeReadRef == null) {
                this.cache.put(batchRange, new RangeReadReference(batchRange, runResult, this.refQueue));
            }
        }
        if (runResult != null) {
            try {
                ShuffleBatchReader.Batch result = this.reader.read(startPosition, endPosition);
                runResult.setResult(result);
            }
            catch (IOException | RuntimeException e) {
                runResult.setException(e);
                HashMap<BatchRange, RangeReadReference> hashMap2 = this.cache;
                synchronized (hashMap2) {
                    this.cache.remove(batchRange);
                }
            }
        }
        return waitResult.getResult();
    }

    static final class RangeReadReference
    extends SoftReference<AsyncReadResult> {
        private final BatchRange range;

        public RangeReadReference(BatchRange range, AsyncReadResult result, ReferenceQueue<? super AsyncReadResult> refQueue) {
            super(result, refQueue);
            this.range = Preconditions.checkNotNull(range);
        }

        public BatchRange getBatchRange() {
            return this.range;
        }
    }

    private static final class AsyncReadResult {
        @Nullable
        private ShuffleBatchReader.Batch batch = null;
        @Nullable
        private Throwable thrown = null;

        private AsyncReadResult() {
        }

        public synchronized void setResult(ShuffleBatchReader.Batch b) {
            this.batch = b;
            this.notifyAll();
        }

        public synchronized void setException(Throwable t) {
            this.thrown = t;
            this.notifyAll();
        }

        public synchronized ShuffleBatchReader.Batch getResult() throws IOException {
            while (this.batch == null && this.thrown == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("interrupted", e);
                }
            }
            if (this.thrown != null) {
                Throwables.propagateIfPossible(this.thrown, IOException.class);
                throw new RuntimeException("unexpected", this.thrown);
            }
            return this.batch;
        }
    }

    static final class BatchRange {
        @Nullable
        private final ShufflePosition startPosition;
        @Nullable
        private final ShufflePosition endPosition;

        public BatchRange(@Nullable ShufflePosition startPosition, @Nullable ShufflePosition endPosition) {
            this.startPosition = startPosition;
            this.endPosition = endPosition;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof BatchRange && Objects.equal(((BatchRange)o).startPosition, this.startPosition) && Objects.equal(((BatchRange)o).endPosition, this.endPosition);
        }

        public int hashCode() {
            return Objects.hashCode(this.startPosition, this.endPosition);
        }
    }
}

