/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.OutputReceiver;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;

public abstract class Operation {
    public final String operationName;
    public final OutputReceiver[] receivers;
    public InitializationState initializationState = InitializationState.UNSTARTED;
    protected final Object initializationStateLock = new Object();
    protected final StateSampler stateSampler;
    protected final int startState;
    protected final int processState;
    protected final int finishState;

    public Operation(String operationName, OutputReceiver[] receivers, String counterPrefix, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler, StateSampler.StateKind stateKind) {
        this.operationName = operationName;
        this.receivers = receivers;
        this.stateSampler = stateSampler;
        this.startState = stateSampler.stateForName(String.valueOf(operationName).concat("-start"), stateKind);
        this.processState = stateSampler.stateForName(String.valueOf(operationName).concat("-process"), stateKind);
        this.finishState = stateSampler.stateForName(String.valueOf(operationName).concat("-finish"), stateKind);
    }

    public Operation(String operationName, OutputReceiver[] receivers, String counterPrefix, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) {
        this(operationName, receivers, counterPrefix, addCounterMutator, stateSampler, StateSampler.StateKind.USER);
    }

    void checkUnstarted() {
        if (!(this.initializationState == InitializationState.UNSTARTED || this.initializationState == InitializationState.FINISHED && this.supportsRestart())) {
            throw new AssertionError((Object)"expecting this instruction to not yet be started");
        }
    }

    void checkStarted() {
        if (this.initializationState != InitializationState.STARTED) {
            throw new AssertionError((Object)"expecting this instruction to be started");
        }
    }

    void checkFinished() {
        if (this.initializationState != InitializationState.FINISHED) {
            throw new AssertionError((Object)"expecting this instruction to be finished");
        }
    }

    boolean isFinished() {
        return this.initializationState == InitializationState.FINISHED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Object object = this.initializationStateLock;
        synchronized (object) {
            this.checkUnstarted();
            this.initializationState = InitializationState.STARTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws Exception {
        Object object = this.initializationStateLock;
        synchronized (object) {
            this.checkStarted();
            this.initializationState = InitializationState.FINISHED;
        }
    }

    public boolean supportsRestart() {
        return false;
    }

    public static enum InitializationState {
        UNSTARTED,
        STARTED,
        FINISHED;

    }
}

