/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.api.client.util.Base64;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.OutputReceiver;
import com.google.cloud.dataflow.sdk.util.common.worker.Receiver;
import com.google.cloud.dataflow.sdk.util.common.worker.ReceivingOperation;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class PartialGroupByKeyOperation
extends ReceivingOperation {
    static final long DEFAULT_MAX_GROUPING_TABLE_BYTES = 100000000L;
    static final int BYTES_PER_JVM_WORD = PartialGroupByKeyOperation.getBytesPerJvmWord();
    static final int PER_KEY_OVERHEAD = 24 * BYTES_PER_JVM_WORD;
    final GroupingTable<Object, Object, Object> groupingTable;

    public PartialGroupByKeyOperation(String operationName, GroupingKeyCreator<?> groupingKeyCreator, SizeEstimator<?> keySizeEstimator, SizeEstimator<?> valueSizeEstimator, PairInfo pairInfo, OutputReceiver[] receivers, String counterPrefix, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) {
        this(operationName, groupingKeyCreator, keySizeEstimator, valueSizeEstimator, null, pairInfo, receivers, counterPrefix, addCounterMutator, stateSampler);
    }

    public PartialGroupByKeyOperation(String operationName, GroupingKeyCreator<?> groupingKeyCreator, SizeEstimator<?> keySizeEstimator, SizeEstimator<?> valueSizeEstimator, Combiner combineFn, PairInfo pairInfo, OutputReceiver[] receivers, String counterPrefix, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) {
        super(operationName, receivers, counterPrefix, addCounterMutator, stateSampler);
        this.groupingTable = combineFn == null ? new BufferingGroupingTable(100000000L, groupingKeyCreator, pairInfo, keySizeEstimator, valueSizeEstimator) : new CombiningGroupingTable(100000000L, groupingKeyCreator, pairInfo, combineFn, keySizeEstimator, valueSizeEstimator);
    }

    public PartialGroupByKeyOperation(String operationName, GroupingKeyCreator<?> groupingKeyCreator, SizeEstimator<?> keySizeEstimator, SizeEstimator<?> valueSizeEstimator, double sizeEstimatorSampleRate, Combiner combineFn, PairInfo pairInfo, OutputReceiver[] receivers, String counterPrefix, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) {
        this(operationName, groupingKeyCreator, new SamplingSizeEstimator(keySizeEstimator, sizeEstimatorSampleRate, 1.0), new SamplingSizeEstimator(valueSizeEstimator, sizeEstimatorSampleRate, 1.0), combineFn, pairInfo, receivers, counterPrefix, addCounterMutator, stateSampler);
    }

    public PartialGroupByKeyOperation(GroupingKeyCreator<?> groupingKeyCreator, SizeEstimator<?> keySizeEstimator, SizeEstimator<?> valueSizeEstimator, PairInfo pairInfo, OutputReceiver outputReceiver, String counterPrefix, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) {
        this(groupingKeyCreator, keySizeEstimator, valueSizeEstimator, null, pairInfo, outputReceiver, counterPrefix, addCounterMutator, stateSampler);
    }

    public PartialGroupByKeyOperation(GroupingKeyCreator<?> groupingKeyCreator, SizeEstimator<?> keySizeEstimator, SizeEstimator<?> valueSizeEstimator, Combiner combineFn, PairInfo pairInfo, OutputReceiver outputReceiver, String counterPrefix, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) {
        this("PartialGroupByKeyOperation", groupingKeyCreator, keySizeEstimator, valueSizeEstimator, combineFn, pairInfo, new OutputReceiver[]{outputReceiver}, counterPrefix, addCounterMutator, stateSampler);
    }

    @Override
    public void process(Object elem) throws Exception {
        try (StateSampler.ScopedState process = this.stateSampler.scopedState(this.processState);){
            if (this.receivers[0] != null) {
                this.groupingTable.put(elem, this.receivers[0]);
            }
        }
    }

    @Override
    public void finish() throws Exception {
        try (StateSampler.ScopedState finish = this.stateSampler.scopedState(this.finishState);){
            this.checkStarted();
            if (this.receivers[0] != null) {
                this.groupingTable.flush(this.receivers[0]);
            }
            super.finish();
        }
    }

    @Override
    public boolean supportsRestart() {
        return true;
    }

    public void setMaxGroupingTableBytes(long maxSize) {
        ((GroupingTable)this.groupingTable).maxSize = maxSize;
    }

    public long getGroupingTableBytes() {
        return ((GroupingTable)this.groupingTable).size;
    }

    static int getBytesPerJvmWord() {
        String wordSizeInBits = System.getProperty("sun.arch.data.model");
        try {
            return Integer.parseInt(wordSizeInBits) / 8;
        }
        catch (NumberFormatException e) {
            return 8;
        }
    }

    public static class SamplingSizeEstimator<T>
    implements SizeEstimator<T> {
        public static final double CONFIDENCE_INTERVAL_SIGMA = 3.0;
        public static final double CONFIDENCE_INTERVAL_SIZE = 0.25;
        public static final long DEFAULT_MIN_SAMPLED = 20L;
        private final SizeEstimator<T> underlying;
        private final double minSampleRate;
        private final double maxSampleRate;
        private final long minSampled;
        private final Random random;
        private long totalElements = 0L;
        private long sampledElements = 0L;
        private long sampledSum = 0L;
        private double sampledSumSquares = 0.0;
        private long estimate;
        private long nextSample = 0L;

        public SamplingSizeEstimator(SizeEstimator<T> underlying, double minSampleRate, double maxSampleRate) {
            this(underlying, minSampleRate, maxSampleRate, 20L, new Random());
        }

        public SamplingSizeEstimator(SizeEstimator<T> underlying, double minSampleRate, double maxSampleRate, long minSampled, Random random) {
            this.underlying = underlying;
            this.minSampleRate = minSampleRate;
            this.maxSampleRate = maxSampleRate;
            this.minSampled = minSampled;
            this.random = random;
        }

        @Override
        public long estimateSize(T element) throws Exception {
            if (this.sampleNow()) {
                return this.recordSample(this.underlying.estimateSize(element));
            }
            return this.estimate;
        }

        private boolean sampleNow() {
            ++this.totalElements;
            return --this.nextSample < 0L;
        }

        private long recordSample(long value) {
            double rate;
            ++this.sampledElements;
            this.sampledSum += value;
            this.sampledSumSquares += (double)(value * value);
            this.estimate = (long)Math.ceil(this.sampledSum / this.sampledElements);
            long target = this.desiredSampleSize();
            this.nextSample = this.sampledElements < this.minSampled || this.sampledElements < target ? 0L : ((rate = SamplingSizeEstimator.cap(this.minSampleRate, this.maxSampleRate, Math.max(1.0 / (double)(this.totalElements - this.minSampled + 1L), (double)target / (double)this.totalElements))) == 1.0 ? 0L : (long)Math.floor(Math.log(this.random.nextDouble()) / Math.log(1.0 - rate)));
            return value;
        }

        private static final double cap(double min, double max, double value) {
            return Math.min(max, Math.max(min, value));
        }

        private long desiredSampleSize() {
            double mean = (double)this.sampledSum / (double)this.sampledElements;
            double sumSquareDiff = this.sampledSumSquares - 2.0 * mean * (double)this.sampledSum + (double)this.sampledElements * mean * mean;
            double stddev = Math.sqrt(sumSquareDiff / (double)(this.sampledElements - 1L));
            double sqrtDesiredSamples = 3.0 * stddev / (0.25 * mean);
            return (long)Math.ceil(sqrtDesiredSamples * sqrtDesiredSamples);
        }
    }

    public static class CombiningGroupingTable<K, InputT, AccumT>
    extends GroupingTable<K, InputT, AccumT> {
        private final Combiner<? super K, InputT, AccumT, ?> combiner;
        private final SizeEstimator<? super K> keySizer;
        private final SizeEstimator<? super AccumT> accumulatorSizer;

        public CombiningGroupingTable(long maxSize, GroupingKeyCreator<? super K> groupingKeyCreator, PairInfo pairInfo, Combiner<? super K, InputT, AccumT, ?> combineFn, SizeEstimator<? super K> keySizer, SizeEstimator<? super AccumT> accumulatorSizer) {
            super(maxSize, groupingKeyCreator, pairInfo);
            this.combiner = combineFn;
            this.keySizer = keySizer;
            this.accumulatorSizer = accumulatorSizer;
        }

        @Override
        public GroupingTable.GroupingTableEntry<K, InputT, AccumT> createTableEntry(final K key) throws Exception {
            return new GroupingTable.GroupingTableEntry<K, InputT, AccumT>(){
                final long keySize;
                AccumT accumulator;
                long accumulatorSize;
                {
                    this.keySize = CombiningGroupingTable.this.keySizer.estimateSize(key);
                    this.accumulator = CombiningGroupingTable.this.combiner.createAccumulator(key);
                    this.accumulatorSize = 0L;
                }

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public AccumT getValue() {
                    return this.accumulator;
                }

                @Override
                public long getSize() {
                    return this.keySize + this.accumulatorSize;
                }

                @Override
                public void add(InputT value) throws Exception {
                    this.accumulator = CombiningGroupingTable.this.combiner.add(key, this.accumulator, value);
                    this.accumulatorSize = CombiningGroupingTable.this.accumulatorSizer.estimateSize(this.accumulator);
                }
            };
        }
    }

    public static class BufferingGroupingTable<K, V>
    extends GroupingTable<K, V, List<V>> {
        public final SizeEstimator<? super K> keySizer;
        public final SizeEstimator<? super V> valueSizer;

        public BufferingGroupingTable(long maxSize, GroupingKeyCreator<? super K> groupingKeyCreator, PairInfo pairInfo, SizeEstimator<? super K> keySizer, SizeEstimator<? super V> valueSizer) {
            super(maxSize, groupingKeyCreator, pairInfo);
            this.keySizer = keySizer;
            this.valueSizer = valueSizer;
        }

        @Override
        public GroupingTable.GroupingTableEntry<K, V, List<V>> createTableEntry(final K key) throws Exception {
            return new GroupingTable.GroupingTableEntry<K, V, List<V>>(){
                long size;
                final List<V> values;
                {
                    this.size = BufferingGroupingTable.this.keySizer.estimateSize(key);
                    this.values = new ArrayList();
                }

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public List<V> getValue() {
                    return this.values;
                }

                @Override
                public long getSize() {
                    return this.size;
                }

                @Override
                public void add(V value) throws Exception {
                    this.values.add(value);
                    this.size += (long)BYTES_PER_JVM_WORD + BufferingGroupingTable.this.valueSizer.estimateSize(value);
                }
            };
        }
    }

    private static abstract class GroupingTable<K, InputT, AccumT> {
        private static final double TARGET_LOAD = 0.9;
        private long maxSize;
        private final GroupingKeyCreator<? super K> groupingKeyCreator;
        private final PairInfo pairInfo;
        private long size = 0L;
        private Map<Object, GroupingTableEntry<K, InputT, AccumT>> table;

        public GroupingTable(long maxSize, GroupingKeyCreator<? super K> groupingKeyCreator, PairInfo pairInfo) {
            this.maxSize = maxSize;
            this.groupingKeyCreator = groupingKeyCreator;
            this.pairInfo = pairInfo;
            this.table = new HashMap<Object, GroupingTableEntry<K, InputT, AccumT>>();
        }

        public abstract GroupingTableEntry<K, InputT, AccumT> createTableEntry(K var1) throws Exception;

        public void put(Object pair, Receiver receiver) throws Exception {
            this.put(this.pairInfo.getKeyFromInputPair(pair), this.pairInfo.getValueFromInputPair(pair), receiver);
        }

        public void put(K key, InputT value, Receiver receiver) throws Exception {
            Object groupingKey = this.groupingKeyCreator.createGroupingKey(key);
            GroupingTableEntry<K, InputT, AccumT> entry = this.table.get(groupingKey);
            if (entry == null) {
                entry = this.createTableEntry(key);
                this.table.put(groupingKey, entry);
                this.size += (long)PER_KEY_OVERHEAD;
            } else {
                this.size -= entry.getSize();
            }
            entry.add(value);
            this.size += entry.getSize();
            if (this.size >= this.maxSize) {
                long targetSize = (long)(0.9 * (double)this.maxSize);
                Iterator<GroupingTableEntry<K, InputT, AccumT>> entries = this.table.values().iterator();
                while (this.size >= targetSize) {
                    if (!entries.hasNext()) {
                        this.size = 0L;
                        break;
                    }
                    GroupingTableEntry<K, InputT, AccumT> toFlush = entries.next();
                    entries.remove();
                    this.size -= toFlush.getSize() + (long)PER_KEY_OVERHEAD;
                    this.output(toFlush, receiver);
                }
            }
        }

        private void output(GroupingTableEntry<K, InputT, AccumT> entry, Receiver receiver) throws Exception {
            receiver.process(this.pairInfo.makeOutputPair(entry.getKey(), entry.getValue()));
        }

        public void flush(Receiver output) throws Exception {
            for (GroupingTableEntry<K, InputT, AccumT> entry : this.table.values()) {
                this.output(entry, output);
            }
            this.table.clear();
            this.size = 0L;
        }

        static interface GroupingTableEntry<K, InputT, AccumT> {
            public K getKey();

            public AccumT getValue();

            public void add(InputT var1) throws Exception;

            public long getSize();
        }
    }

    public static class StructuralByteArray {
        byte[] value;

        public StructuralByteArray(byte[] value) {
            this.value = value;
        }

        public byte[] getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o instanceof StructuralByteArray) {
                StructuralByteArray that = (StructuralByteArray)o;
                return Arrays.equals(this.value, that.value);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }

        public String toString() {
            String string = String.valueOf(Base64.encodeBase64String((byte[])this.value));
            return string.length() != 0 ? "base64:".concat(string) : new String("base64:");
        }
    }

    public static interface Combiner<K, InputT, AccumT, OutputT> {
        public AccumT createAccumulator(K var1);

        public AccumT add(K var1, AccumT var2, InputT var3);

        public AccumT merge(K var1, Iterable<AccumT> var2);

        public OutputT extract(K var1, AccumT var2);
    }

    public static interface PairInfo {
        public Object getKeyFromInputPair(Object var1);

        public Object getValueFromInputPair(Object var1);

        public Object makeOutputPair(Object var1, Object var2);
    }

    public static interface SizeEstimator<T> {
        public long estimateSize(T var1) throws Exception;
    }

    public static interface GroupingKeyCreator<K> {
        public Object createGroupingKey(K var1) throws Exception;
    }
}

