/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.util.common.ForwardingReiterator;
import com.google.cloud.dataflow.sdk.util.common.Reiterator;
import com.google.cloud.dataflow.sdk.util.common.worker.ProgressTracker;

public final class ProgressTrackingReiterator<T>
extends ForwardingReiterator<T> {
    private ProgressTracker<T> tracker;

    public ProgressTrackingReiterator(Reiterator<T> base, ProgressTracker<T> tracker) {
        super(base);
        this.tracker = Preconditions.checkNotNull(tracker);
    }

    @Override
    public T next() {
        Object result = super.next();
        this.tracker.saw(result);
        return result;
    }

    @Override
    protected ProgressTrackingReiterator<T> clone() {
        ProgressTrackingReiterator result = (ProgressTrackingReiterator)super.clone();
        result.tracker = this.tracker.copy();
        return result;
    }
}

