/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import com.google.cloud.dataflow.sdk.util.common.worker.WorkExecutor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class WorkProgressUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(WorkProgressUpdater.class);
    public static final long DEFAULT_LEASE_DURATION_MILLIS = 180000L;
    private static final long DEFAULT_LEASE_RENEWAL_LATENCY_MARGIN = 5000L;
    private static final long DEFAULT_MIN_REPORTING_INTERVAL_MILLIS = 5000L;
    private static final long DEFAULT_MAX_REPORTING_INTERVAL_MILLIS = 600000L;
    protected final WorkExecutor worker;
    private final ScheduledExecutorService executor;
    protected long requestedLeaseDurationMs;
    protected long progressReportIntervalMs;
    protected Reader.DynamicSplitResult dynamicSplitResultToReport;

    public WorkProgressUpdater(WorkExecutor worker) {
        this.worker = worker;
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("WorkProgressUpdater-%d").build());
    }

    public void startReportingProgress() {
        long leaseRemainingTime = this.leaseRemainingTime(this.getWorkUnitLeaseExpirationTimestamp());
        this.progressReportIntervalMs = this.nextProgressReportInterval(this.getWorkUnitSuggestedReportingInterval(), leaseRemainingTime);
        this.requestedLeaseDurationMs = 180000L;
        LOG.debug("Started reporting progress for work item: {}", (Object)this.workString());
        this.scheduleNextUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReportingProgress() throws Exception {
        ScheduledExecutorService scheduledExecutorService = this.executor;
        synchronized (scheduledExecutorService) {
            this.executor.shutdownNow();
        }
        if (this.dynamicSplitResultToReport != null) {
            LOG.debug("Sending final progress update with unreported split: {} for work item: {}", (Object)this.dynamicSplitResultToReport, (Object)this.workString());
            this.reportProgressHelper();
        }
        LOG.debug("Stopped reporting progress for work item: {}", (Object)this.workString());
    }

    protected final long nextProgressReportInterval(long suggestedInterval, long leaseRemainingTime) {
        suggestedInterval = Math.min(suggestedInterval, leaseRemainingTime - this.getLeaseRenewalLatencyMargin());
        return Math.min(Math.max(this.getMinReportingInterval(), suggestedInterval), this.getMaxReportingInterval());
    }

    private void scheduleNextUpdate() {
        if (this.executor.isShutdown()) {
            return;
        }
        this.executor.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ScheduledExecutorService scheduledExecutorService = WorkProgressUpdater.this.executor;
                synchronized (scheduledExecutorService) {
                    if (WorkProgressUpdater.this.executor.isShutdown()) {
                        return;
                    }
                    WorkProgressUpdater.this.reportProgress();
                }
            }
        }, this.progressReportIntervalMs, TimeUnit.MILLISECONDS);
        LOG.debug("Next work progress update for work item {} scheduled to occur in {} ms.", (Object)this.workString(), (Object)this.progressReportIntervalMs);
    }

    private void reportProgress() {
        LOG.debug("Updating progress on work item {}", (Object)this.workString());
        try {
            this.reportProgressHelper();
        }
        catch (Throwable e) {
            LOG.warn("Error reporting workitem progress update to Dataflow service: ", e);
        }
        finally {
            this.scheduleNextUpdate();
        }
    }

    protected long leaseRemainingTime(long leaseExpirationTimestamp) {
        long now = System.currentTimeMillis();
        if (leaseExpirationTimestamp < now) {
            LOG.debug("Lease remaining time for {} is 0 ms.", (Object)this.workString());
            return 0L;
        }
        LOG.debug("Lease remaining time for {} is {} ms.", (Object)this.workString(), (Object)(leaseExpirationTimestamp - now));
        return leaseExpirationTimestamp - now;
    }

    public Reader.DynamicSplitResult getDynamicSplitResultToReport() {
        return this.dynamicSplitResultToReport;
    }

    protected abstract void reportProgressHelper() throws Exception;

    protected abstract long getWorkUnitLeaseExpirationTimestamp();

    protected long getWorkUnitSuggestedReportingInterval() {
        return this.leaseRemainingTime(this.getWorkUnitLeaseExpirationTimestamp()) / 2L;
    }

    protected long getMinReportingInterval() {
        return 5000L;
    }

    protected long getMaxReportingInterval() {
        return 600000L;
    }

    protected long getLeaseRenewalLatencyMargin() {
        return 5000L;
    }

    protected abstract String workString();
}

