/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.worker.OutputReceiver;
import com.google.cloud.dataflow.sdk.util.common.worker.ReceivingOperation;
import com.google.cloud.dataflow.sdk.util.common.worker.Sink;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;

public class WriteOperation
extends ReceivingOperation {
    public final Sink<?> sink;
    final Counter<Long> byteCount;
    Sink.SinkWriter<Object> writer;

    public WriteOperation(String operationName, Sink<?> sink, OutputReceiver[] receivers, String counterPrefix, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) {
        super(operationName, receivers, counterPrefix, addCounterMutator, stateSampler, sink.getStateSamplerStateKind());
        this.sink = sink;
        this.byteCount = addCounterMutator.addCounter(Counter.longs(this.bytesCounterName(counterPrefix, operationName), Counter.AggregationKind.SUM));
    }

    public WriteOperation(Sink<?> sink, String counterPrefix, CounterSet.AddCounterMutator addCounterMutator, StateSampler stateSampler) {
        this("WriteOperation", sink, new OutputReceiver[0], counterPrefix, addCounterMutator, stateSampler);
    }

    protected String bytesCounterName(String counterPrefix, String operationName) {
        return String.valueOf(operationName).concat("-ByteCount");
    }

    public Sink<?> getSink() {
        return this.sink;
    }

    @Override
    public void start() throws Exception {
        try (StateSampler.ScopedState start = this.stateSampler.scopedState(this.startState);){
            assert (start != null);
            super.start();
            this.writer = this.sink.writer();
        }
    }

    @Override
    public void process(Object outputElem) throws Exception {
        try (StateSampler.ScopedState process = this.stateSampler.scopedState(this.processState);){
            assert (process != null);
            this.checkStarted();
            this.byteCount.addValue(this.writer.add(outputElem));
        }
    }

    @Override
    public void finish() throws Exception {
        try (StateSampler.ScopedState finish = this.stateSampler.scopedState(this.finishState);){
            assert (finish != null);
            this.checkStarted();
            this.writer.close();
            super.finish();
        }
    }

    @Override
    public boolean supportsRestart() {
        return this.sink.supportsRestart();
    }

    public Counter<Long> getByteCount() {
        return this.byteCount;
    }
}

