/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.state;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.util.state.BagState;
import com.google.cloud.dataflow.sdk.util.state.CombiningValueStateInternal;
import com.google.cloud.dataflow.sdk.util.state.MergingStateInternals;
import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.StateContents;
import com.google.cloud.dataflow.sdk.util.state.StateNamespace;
import com.google.cloud.dataflow.sdk.util.state.StateTable;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.ValueState;
import com.google.cloud.dataflow.sdk.util.state.WatermarkStateInternal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class InMemoryStateInternals
extends MergingStateInternals {
    protected final StateTable inMemoryState = new StateTable(){

        @Override
        protected StateTag.StateBinder binderForNamespace(StateNamespace namespace) {
            return new StateTag.StateBinder(){

                @Override
                public <T> ValueState<T> bindValue(StateTag<ValueState<T>> address, Coder<T> coder) {
                    return new InMemoryValue();
                }

                @Override
                public <T> BagState<T> bindBag(StateTag<BagState<T>> address, Coder<T> elemCoder) {
                    return new InMemoryBag();
                }

                @Override
                public <InputT, AccumT, OutputT> CombiningValueStateInternal<InputT, AccumT, OutputT> bindCombiningValue(StateTag<CombiningValueStateInternal<InputT, AccumT, OutputT>> address, Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
                    return new InMemoryCombiningValue(combineFn);
                }

                @Override
                public <T> WatermarkStateInternal bindWatermark(StateTag<WatermarkStateInternal> address) {
                    return new WatermarkStateInternalImplementation();
                }
            };
        }
    };

    public void clear() {
        this.inMemoryState.clear();
    }

    protected boolean isEmptyForTesting(State state) {
        return ((InMemoryState)((Object)state)).isEmptyForTesting();
    }

    @Override
    public <T extends State> T state(StateNamespace namespace, StateTag<T> address) {
        return this.inMemoryState.get(namespace, address);
    }

    private static final class InMemoryBag<T>
    implements BagState<T>,
    InMemoryState {
        private final List<T> contents = new ArrayList<T>();

        private InMemoryBag() {
        }

        @Override
        public void clear() {
            this.contents.clear();
        }

        @Override
        public StateContents<Iterable<T>> get() {
            return new StateContents<Iterable<T>>(){

                @Override
                public Iterable<T> read() {
                    return InMemoryBag.this.contents;
                }
            };
        }

        @Override
        public void add(T input) {
            this.contents.add(input);
        }

        @Override
        public boolean isEmptyForTesting() {
            return this.contents.isEmpty();
        }

        @Override
        public StateContents<Boolean> isEmpty() {
            return new StateContents<Boolean>(){

                @Override
                public Boolean read() {
                    return InMemoryBag.this.contents.isEmpty();
                }
            };
        }
    }

    private final class InMemoryCombiningValue<InputT, AccumT, OutputT>
    implements CombiningValueStateInternal<InputT, AccumT, OutputT>,
    InMemoryState {
        private boolean isCleared = true;
        private final Combine.CombineFn<InputT, AccumT, OutputT> combineFn;
        private AccumT accum;

        private InMemoryCombiningValue(Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            this.combineFn = combineFn;
            this.accum = combineFn.createAccumulator();
        }

        @Override
        public void clear() {
            this.accum = this.combineFn.createAccumulator();
            this.isCleared = true;
        }

        @Override
        public StateContents<OutputT> get() {
            return new StateContents<OutputT>(){

                @Override
                public OutputT read() {
                    return InMemoryCombiningValue.this.combineFn.extractOutput(InMemoryCombiningValue.this.accum);
                }
            };
        }

        @Override
        public void add(InputT input) {
            this.isCleared = false;
            this.accum = this.combineFn.addInput(this.accum, input);
        }

        @Override
        public StateContents<AccumT> getAccum() {
            return new StateContents<AccumT>(){

                @Override
                public AccumT read() {
                    return InMemoryCombiningValue.this.accum;
                }
            };
        }

        @Override
        public StateContents<Boolean> isEmpty() {
            return new StateContents<Boolean>(){

                @Override
                public Boolean read() {
                    return InMemoryCombiningValue.this.isCleared;
                }
            };
        }

        @Override
        public void addAccum(AccumT accum) {
            this.isCleared = false;
            this.accum = this.combineFn.mergeAccumulators(Arrays.asList(this.accum, accum));
        }

        @Override
        public boolean isEmptyForTesting() {
            return this.isCleared;
        }
    }

    private final class WatermarkStateInternalImplementation
    implements WatermarkStateInternal,
    InMemoryState {
        private Instant minimumHold = null;

        private WatermarkStateInternalImplementation() {
        }

        @Override
        public void clear() {
            this.minimumHold = null;
        }

        @Override
        public StateContents<Instant> get() {
            return new StateContents<Instant>(){

                @Override
                public Instant read() {
                    return WatermarkStateInternalImplementation.this.minimumHold;
                }
            };
        }

        @Override
        public void add(Instant watermarkHold) {
            if (this.minimumHold == null || this.minimumHold.isAfter((ReadableInstant)watermarkHold)) {
                this.minimumHold = watermarkHold;
            }
        }

        @Override
        public boolean isEmptyForTesting() {
            return this.minimumHold == null;
        }

        @Override
        public StateContents<Boolean> isEmpty() {
            return new StateContents<Boolean>(){

                @Override
                public Boolean read() {
                    return WatermarkStateInternalImplementation.this.minimumHold == null;
                }
            };
        }

        public String toString() {
            return Objects.toString(this.minimumHold);
        }
    }

    private final class InMemoryValue<T>
    implements ValueState<T>,
    InMemoryState {
        private boolean isCleared = true;
        private T value = null;

        private InMemoryValue() {
        }

        @Override
        public void clear() {
            this.value = null;
            this.isCleared = true;
        }

        @Override
        public StateContents<T> get() {
            return new StateContents<T>(){

                @Override
                public T read() {
                    return InMemoryValue.this.value;
                }
            };
        }

        @Override
        public void set(T input) {
            this.isCleared = false;
            this.value = input;
        }

        @Override
        public boolean isEmptyForTesting() {
            return this.isCleared;
        }
    }

    private static interface InMemoryState {
        public boolean isEmptyForTesting();
    }
}

