/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.state;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.util.state.BagState;
import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.StateContents;
import java.util.ArrayList;
import java.util.Collection;

class MergedBag<T>
implements BagState<T> {
    private final Collection<BagState<T>> sources;
    private final BagState<T> result;

    public MergedBag(Collection<BagState<T>> sources, BagState<T> result) {
        this.sources = sources;
        this.result = result;
    }

    @Override
    public void clear() {
        for (State state : this.sources) {
            state.clear();
        }
        this.result.clear();
    }

    @Override
    public void add(T input) {
        this.result.add(input);
    }

    @Override
    public StateContents<Iterable<T>> get() {
        final ArrayList futures = new ArrayList(this.sources.size());
        for (BagState<T> source : this.sources) {
            futures.add(source.get());
        }
        return new StateContents<Iterable<T>>(){

            @Override
            public Iterable<T> read() {
                ArrayList result = new ArrayList();
                for (StateContents future : futures) {
                    Iterables.addAll(result, (Iterable)future.read());
                }
                return result;
            }
        };
    }

    @Override
    public StateContents<Boolean> isEmpty() {
        final ArrayList<StateContents<Boolean>> futures = new ArrayList<StateContents<Boolean>>(this.sources.size());
        for (BagState<T> source : this.sources) {
            futures.add(source.isEmpty());
        }
        return new StateContents<Boolean>(){

            @Override
            public Boolean read() {
                for (StateContents future : futures) {
                    if (((Boolean)future.read()).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

