/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.state;

import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.StateContents;
import com.google.cloud.dataflow.sdk.util.state.WatermarkStateInternal;
import java.util.ArrayList;
import java.util.Collection;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class MergedWatermarkStateInternal
implements WatermarkStateInternal {
    private final Collection<WatermarkStateInternal> sources;
    private final WatermarkStateInternal result;

    public MergedWatermarkStateInternal(Collection<WatermarkStateInternal> sources, WatermarkStateInternal result) {
        this.sources = sources;
        this.result = result;
    }

    @Override
    public void clear() {
        for (State state : this.sources) {
            state.clear();
        }
        this.result.clear();
    }

    @Override
    public void add(Instant watermarkHold) {
        this.result.add(watermarkHold);
    }

    @Override
    public StateContents<Instant> get() {
        final ArrayList reads = new ArrayList(this.sources.size());
        for (WatermarkStateInternal source : this.sources) {
            reads.add(source.get());
        }
        return new StateContents<Instant>(){

            @Override
            public Instant read() {
                Instant minimum = null;
                for (StateContents read : reads) {
                    Instant input = (Instant)read.read();
                    if (minimum != null && (input == null || !minimum.isAfter((ReadableInstant)input))) continue;
                    minimum = input;
                }
                if (minimum != null) {
                    MergedWatermarkStateInternal.this.clear();
                    MergedWatermarkStateInternal.this.add(minimum);
                }
                return minimum;
            }
        };
    }

    @Override
    public StateContents<Boolean> isEmpty() {
        final ArrayList<StateContents<Boolean>> futures = new ArrayList<StateContents<Boolean>>(this.sources.size());
        for (WatermarkStateInternal source : this.sources) {
            futures.add(source.isEmpty());
        }
        return new StateContents<Boolean>(){

            @Override
            public Boolean read() {
                for (StateContents future : futures) {
                    if (((Boolean)future.read()).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

