/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.state;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Splitter;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.state.StateNamespace;
import java.util.List;
import java.util.Objects;

public class StateNamespaces {
    private static final Splitter SLASH_SPLITTER = Splitter.on('/');

    public static StateNamespace global() {
        return new GlobalNamespace();
    }

    public static <W extends BoundedWindow> StateNamespace window(Coder<W> windowCoder, W window) {
        return new WindowNamespace(windowCoder, window, null);
    }

    public static <W extends BoundedWindow> StateNamespace windowAndTrigger(Coder<W> windowCoder, W window, int triggerIdx) {
        return new WindowAndTriggerNamespace(windowCoder, window, triggerIdx, null);
    }

    private StateNamespaces() {
    }

    public static <W extends BoundedWindow> StateNamespace fromString(String stringKey, Coder<W> windowCoder) {
        if (!stringKey.startsWith("/") || !stringKey.endsWith("/")) {
            throw new RuntimeException(new StringBuilder(28 + String.valueOf(stringKey).length()).append("Invalid namespace string: '").append(stringKey).append("'").toString());
        }
        if ("/".equals(stringKey)) {
            return StateNamespaces.global();
        }
        List<String> parts = SLASH_SPLITTER.splitToList(stringKey);
        if (parts.size() != 3 && parts.size() != 4) {
            throw new RuntimeException(new StringBuilder(28 + String.valueOf(stringKey).length()).append("Invalid namespace string: '").append(stringKey).append("'").toString());
        }
        if (!parts.get(0).isEmpty() || !parts.get(parts.size() - 1).isEmpty()) {
            throw new RuntimeException(new StringBuilder(28 + String.valueOf(stringKey).length()).append("Invalid namespace string: '").append(stringKey).append("'").toString());
        }
        try {
            BoundedWindow window = (BoundedWindow)CoderUtils.decodeFromBase64(windowCoder, parts.get(1));
            if (parts.size() > 3) {
                int index = Integer.parseInt(parts.get(2), 36);
                return StateNamespaces.windowAndTrigger(windowCoder, window, index);
            }
            return StateNamespaces.window(windowCoder, window);
        }
        catch (Exception e) {
            throw new RuntimeException(new StringBuilder(28 + String.valueOf(stringKey).length()).append("Invalid namespace string: '").append(stringKey).append("'").toString(), e);
        }
    }

    public static class WindowAndTriggerNamespace<W extends BoundedWindow>
    implements StateNamespace {
        private static final String WINDOW_AND_TRIGGER_FORMAT = "/%s/%s/";
        private static final int TRIGGER_RADIX = 36;
        private Coder<W> windowCoder;
        private W window;
        private int triggerIndex;

        private WindowAndTriggerNamespace(Coder<W> windowCoder, W window, int triggerIndex) {
            this.windowCoder = windowCoder;
            this.window = window;
            this.triggerIndex = triggerIndex;
        }

        public W getWindow() {
            return this.window;
        }

        public int getTriggerIndex() {
            return this.triggerIndex;
        }

        @Override
        public String stringKey() {
            try {
                return String.format(WINDOW_AND_TRIGGER_FORMAT, CoderUtils.encodeToBase64(this.windowCoder, this.window), Integer.toString(this.triggerIndex, 36).toUpperCase());
            }
            catch (CoderException e) {
                String string = String.valueOf(this.window);
                throw new RuntimeException(new StringBuilder(42 + String.valueOf(string).length()).append("Unable to generate string key from window ").append(string).toString(), e);
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WindowAndTriggerNamespace)) {
                return false;
            }
            WindowAndTriggerNamespace that = (WindowAndTriggerNamespace)obj;
            return this.triggerIndex == that.triggerIndex && Objects.equals(this.window, that.window);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{Namespace.WINDOW_AND_TRIGGER, this.window, this.triggerIndex});
        }

        public String toString() {
            String string = String.valueOf(this.window);
            int n = this.triggerIndex;
            return new StringBuilder(30 + String.valueOf(string).length()).append("WindowAndTrigger(").append(string).append(",").append(n).append(")").toString();
        }

        /* synthetic */ WindowAndTriggerNamespace(Coder x0, BoundedWindow x1, int x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static class WindowNamespace<W extends BoundedWindow>
    implements StateNamespace {
        private static final String WINDOW_FORMAT = "/%s/";
        private Coder<W> windowCoder;
        private W window;

        private WindowNamespace(Coder<W> windowCoder, W window) {
            this.windowCoder = windowCoder;
            this.window = window;
        }

        public W getWindow() {
            return this.window;
        }

        @Override
        public String stringKey() {
            try {
                return String.format(WINDOW_FORMAT, CoderUtils.encodeToBase64(this.windowCoder, this.window));
            }
            catch (CoderException e) {
                String string = String.valueOf(this.window);
                throw new RuntimeException(new StringBuilder(42 + String.valueOf(string).length()).append("Unable to generate string key from window ").append(string).toString(), e);
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WindowNamespace)) {
                return false;
            }
            WindowNamespace that = (WindowNamespace)obj;
            return Objects.equals(this.window, that.window);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{Namespace.WINDOW, this.window});
        }

        public String toString() {
            String string = String.valueOf(this.window);
            return new StringBuilder(8 + String.valueOf(string).length()).append("Window(").append(string).append(")").toString();
        }

        /* synthetic */ WindowNamespace(Coder x0, BoundedWindow x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static class GlobalNamespace
    implements StateNamespace {
        private static final String GLOBAL_STRING = "/";

        @Override
        public String stringKey() {
            return GLOBAL_STRING;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof GlobalNamespace;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{Namespace.GLOBAL});
        }

        public String toString() {
            return "Global";
        }
    }

    private static enum Namespace {
        GLOBAL,
        WINDOW,
        WINDOW_AND_TRIGGER;

    }
}

