/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.state;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Supplier;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Table;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Tables;
import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.StateNamespace;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class StateTable {
    private final Table<StateNamespace, StateTag<?>, State> stateTable = Tables.newCustomTable(new HashMap(), new Supplier<Map<StateTag<?>, State>>(){

        @Override
        public Map<StateTag<?>, State> get() {
            return new HashMap();
        }
    });

    public <StateT extends State> StateT get(StateNamespace namespace, StateTag<StateT> tag) {
        State storage = this.stateTable.get(namespace, tag);
        if (storage != null) {
            State typedStorage = storage;
            return (StateT)typedStorage;
        }
        StateT typedStorage = tag.bind(this.binderForNamespace(namespace));
        this.stateTable.put(namespace, tag, (State)typedStorage);
        return typedStorage;
    }

    public void clearNamespace(StateNamespace namespace) {
        this.stateTable.rowKeySet().remove(namespace);
    }

    public void clear() {
        this.stateTable.clear();
    }

    public Iterable<State> values() {
        return this.stateTable.values();
    }

    public boolean isNamespaceInUse(StateNamespace namespace) {
        return this.stateTable.containsRow(namespace);
    }

    public Map<StateTag<?>, State> getTagsInUse(StateNamespace namespace) {
        return this.stateTable.row(namespace);
    }

    public Set<StateNamespace> getNamespacesInUse() {
        return this.stateTable.rowKeySet();
    }

    protected abstract StateTag.StateBinder binderForNamespace(StateNamespace var1);
}

