/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.values;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import com.google.cloud.dataflow.sdk.values.PValue;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import com.google.cloud.dataflow.sdk.values.TupleTagList;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import com.google.cloud.dataflow.sdk.values.TypedPValue;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class PCollectionTuple
implements PInput,
POutput {
    Pipeline pipeline;
    final Map<TupleTag<?>, PCollection<?>> pcollectionMap;

    public static PCollectionTuple empty(Pipeline pipeline) {
        return new PCollectionTuple(pipeline);
    }

    public static <T> PCollectionTuple of(TupleTag<T> tag, PCollection<T> pc) {
        return PCollectionTuple.empty(pc.getPipeline()).and(tag, pc);
    }

    public <T> PCollectionTuple and(TupleTag<T> tag, PCollection<T> pc) {
        if (pc.getPipeline() != this.pipeline) {
            throw new IllegalArgumentException("PCollections come from different Pipelines");
        }
        pc.setTypeDescriptorInternal((TypeDescriptor)tag.getTypeDescriptor());
        return new PCollectionTuple(this.pipeline, new ImmutableMap.Builder().putAll(this.pcollectionMap).put(tag, pc).build());
    }

    public <T> boolean has(TupleTag<T> tag) {
        return this.pcollectionMap.containsKey(tag);
    }

    public <T> PCollection<T> get(TupleTag<T> tag) {
        PCollection<?> pcollection = this.pcollectionMap.get(tag);
        if (pcollection == null) {
            throw new IllegalArgumentException("TupleTag not found in this PCollectionTuple tuple");
        }
        return pcollection;
    }

    public Map<TupleTag<?>, PCollection<?>> getAll() {
        return this.pcollectionMap;
    }

    public <OutputT extends POutput> OutputT apply(PTransform<PCollectionTuple, OutputT> t) {
        return Pipeline.applyTransform(this, t);
    }

    public <OutputT extends POutput> OutputT apply(String name, PTransform<PCollectionTuple, OutputT> t) {
        return Pipeline.applyTransform(name, this, t);
    }

    PCollectionTuple(Pipeline pipeline) {
        this(pipeline, new LinkedHashMap());
    }

    PCollectionTuple(Pipeline pipeline, Map<TupleTag<?>, PCollection<?>> pcollectionMap) {
        this.pipeline = pipeline;
        this.pcollectionMap = Collections.unmodifiableMap(pcollectionMap);
    }

    public static PCollectionTuple ofPrimitiveOutputsInternal(Pipeline pipeline, TupleTagList outputTags, WindowingStrategy<?, ?> windowingStrategy, PCollection.IsBounded isBounded) {
        LinkedHashMap pcollectionMap = new LinkedHashMap();
        for (TupleTag<?> outputTag : outputTags.tupleTags) {
            if (pcollectionMap.containsKey(outputTag)) {
                throw new IllegalArgumentException("TupleTag already present in this tuple");
            }
            TypeDescriptor<?> token = outputTag.getTypeDescriptor();
            TypedPValue outputCollection = PCollection.createPrimitiveOutputInternal(pipeline, windowingStrategy, isBounded).setTypeDescriptorInternal((TypeDescriptor)token);
            pcollectionMap.put(outputTag, (PCollection<?>)outputCollection);
        }
        return new PCollectionTuple(pipeline, pcollectionMap);
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public Collection<? extends PValue> expand() {
        return this.pcollectionMap.values();
    }

    @Override
    public void recordAsOutput(AppliedPTransform<?, ?, ?> transform) {
        int i = 0;
        for (Map.Entry<TupleTag<?>, PCollection<?>> entry : this.pcollectionMap.entrySet()) {
            TupleTag<?> tag = entry.getKey();
            PCollection<?> pc = entry.getValue();
            pc.recordAsOutput(transform, tag.getOutName(i));
            ++i;
        }
    }

    @Override
    public void finishSpecifying() {
        for (PCollection<?> pc : this.pcollectionMap.values()) {
            pc.finishSpecifying();
        }
    }

    @Override
    public void finishSpecifyingOutput() {
        for (PCollection<?> pc : this.pcollectionMap.values()) {
            pc.finishSpecifyingOutput();
        }
    }
}

