/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.values;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.reflect.Invokable;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.reflect.Parameter;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;

public abstract class TypeDescriptor<T>
implements Serializable {
    private final TypeToken<T> token;

    private TypeDescriptor(TypeToken<T> token) {
        this.token = token;
    }

    protected TypeDescriptor() {
        this.token = new TypeToken<T>(this.getClass()){};
    }

    protected TypeDescriptor(Class<?> clazz) {
        TypeToken unresolvedToken = new TypeToken<T>(this.getClass()){};
        this.token = TypeToken.of(clazz).resolveType(unresolvedToken.getType());
    }

    public static <T> TypeDescriptor<T> of(Class<T> type) {
        return new SimpleTypeDescriptor<T>(TypeToken.of(type));
    }

    public static TypeDescriptor<?> of(Type type) {
        return new SimpleTypeDescriptor(TypeToken.of(type));
    }

    public Type getType() {
        return this.token.getType();
    }

    public Class<? super T> getRawType() {
        return this.token.getRawType();
    }

    public TypeDescriptor<?> getComponentType() {
        return new SimpleTypeDescriptor(this.token.getComponentType());
    }

    public final TypeDescriptor<? super T> getSupertype(Class<? super T> superclass) {
        return new SimpleTypeDescriptor<T>(this.token.getSupertype(superclass));
    }

    public final boolean isArray() {
        return this.token.isArray();
    }

    public final TypeVariable<Class<? super T>> getTypeParameter(String paramName) {
        Class<T> rawType = this.getRawType();
        for (TypeVariable<Class<T>> param : rawType.getTypeParameters()) {
            if (!param.getName().equals(paramName)) continue;
            TypeVariable<Class<T>> typedParam = param;
            return typedParam;
        }
        String string = String.valueOf(this.getRawType());
        throw new IllegalArgumentException(new StringBuilder(34 + String.valueOf(paramName).length() + String.valueOf(string).length()).append("No type parameter named ").append(paramName).append(" found on ").append(string).toString());
    }

    public final boolean isSupertypeOf(TypeDescriptor<?> source) {
        return this.token.isAssignableFrom(source.token);
    }

    public final boolean isSubtypeOf(TypeDescriptor<?> parent) {
        return parent.token.isAssignableFrom(this.token);
    }

    public List<TypeDescriptor<?>> getArgumentTypes(Method method) {
        Invokable<T, Object> typedMethod = this.token.method(method);
        ArrayList<TypeDescriptor<?>> argTypes = Lists.newArrayList();
        for (Parameter parameter : typedMethod.getParameters()) {
            argTypes.add(new SimpleTypeDescriptor(parameter.getType()));
        }
        return argTypes;
    }

    public TypeDescriptor<?> resolveType(Type type) {
        return new SimpleTypeDescriptor(this.token.resolveType(type));
    }

    public Iterable<TypeDescriptor> getInterfaces() {
        ArrayList<TypeDescriptor> interfaces = Lists.newArrayList();
        for (TypeToken interfaceToken : this.token.getTypes().interfaces()) {
            interfaces.add(new SimpleTypeDescriptor(interfaceToken));
        }
        return interfaces;
    }

    public Iterable<TypeDescriptor> getClasses() {
        ArrayList<TypeDescriptor> classes = Lists.newArrayList();
        for (TypeToken classToken : this.token.getTypes().classes()) {
            classes.add(new SimpleTypeDescriptor(classToken));
        }
        return classes;
    }

    public String toString() {
        return this.token.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof TypeDescriptor)) {
            return false;
        }
        TypeDescriptor descriptor = (TypeDescriptor)other;
        return this.token.equals(descriptor.token);
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    private static final class SimpleTypeDescriptor<T>
    extends TypeDescriptor<T> {
        SimpleTypeDescriptor(TypeToken<T> typeToken) {
            super(typeToken);
        }
    }
}

