/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.tree.content;

import com.lyncode.jtwig.JtwigContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.functions.util.ObjectIterator;
import com.lyncode.jtwig.resource.JtwigResource;
import com.lyncode.jtwig.tree.api.Content;
import com.lyncode.jtwig.tree.api.Expression;
import com.lyncode.jtwig.tree.expressions.Variable;
import com.lyncode.jtwig.tree.structural.Block;
import java.io.OutputStream;

public class ForLoop
implements Content {
    protected Variable variable;
    protected Content content;
    protected Expression expression;

    public ForLoop(Variable variable, Expression list) {
        this.variable = variable;
        this.expression = list;
    }

    public boolean setContent(Content content) {
        this.content = content;
        return true;
    }

    @Override
    public boolean render(OutputStream outputStream, JtwigContext context) throws RenderException {
        try {
            ObjectIterator iterator = new ObjectIterator(this.expression.calculate(context));
            Loop loop = new Loop(iterator.size());
            context.set("loop", loop);
            int index = 0;
            while (iterator.hasNext()) {
                loop.update(index++);
                Object object = iterator.next();
                context.set(this.variable.getIdentifier(), object);
                this.content.render(outputStream, context);
            }
            return true;
        }
        catch (CalculateException e) {
            throw new RenderException(e);
        }
    }

    @Override
    public Content compile(JtwigResource resource) throws CompileException {
        this.content = this.content.compile(resource);
        return this;
    }

    @Override
    public boolean replace(Block expression) throws CompileException {
        return this.content.replace(expression);
    }

    public String toString() {
        return "For each element of " + this.expression + " render " + this.content;
    }

    public static class Loop {
        private int index = 0;
        private int length;

        public Loop(int length) {
            this.length = length;
        }

        public void update(int index) {
            this.index = index;
        }

        public int getLength() {
            return this.length;
        }

        public int getIndex() {
            return this.index;
        }

        public int getRevindex() {
            return this.length - this.index - 1;
        }

        public boolean isFirst() {
            return this.index == 0;
        }

        public boolean isLast() {
            return this.index == this.length - 1;
        }
    }
}

