/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig;

import com.lyncode.jtwig.JtwigModelMap;
import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.configuration.JtwigConfiguration;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.parser.JtwigParser;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.resource.FileJtwigResource;
import com.lyncode.jtwig.resource.JtwigResource;
import com.lyncode.jtwig.resource.StringJtwigResource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;

public class JtwigTemplate {
    private final JtwigResource resource;
    private final JtwigConfiguration configuration;

    public static JtwigTemplate fromString(String template) {
        return new JtwigTemplate(template, new JtwigConfiguration());
    }

    public JtwigTemplate(JtwigResource resource, JtwigConfiguration configuration) {
        this.resource = resource;
        this.configuration = configuration;
    }

    public JtwigTemplate(String content, JtwigConfiguration configuration) {
        this(new StringJtwigResource(content), configuration);
    }

    public JtwigTemplate(File file, JtwigConfiguration configuration) {
        this(new FileJtwigResource(file), configuration);
    }

    public void output(OutputStream outputStream, JtwigModelMap modelMap) throws ParseException, CompileException, RenderException {
        JtwigParser parser = new JtwigParser(this.configuration.parse());
        CompileContext compileContext = new CompileContext(this.resource, parser, this.configuration.compile());
        RenderContext renderContext = RenderContext.create(this.configuration.render(), modelMap, outputStream);
        parser.parse(this.resource).compile(compileContext).render(renderContext);
    }

    public String output(JtwigModelMap modelMap) throws ParseException, CompileException, RenderException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.output(outputStream, modelMap);
        return outputStream.toString();
    }

    public Renderable compile() throws ParseException, CompileException {
        JtwigParser parser = new JtwigParser(this.configuration.parse());
        return parser.parse(this.resource).compile(new CompileContext(this.resource, parser, this.configuration.compile()));
    }
}

