/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.addons.filter;

import com.google.common.base.Function;
import com.lyncode.jtwig.addons.AddonModel;
import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.expressions.model.FunctionElement;
import com.lyncode.jtwig.expressions.model.OperationBinary;
import com.lyncode.jtwig.parser.model.JtwigPosition;
import com.lyncode.jtwig.render.RenderContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Filter
extends AddonModel<Filter> {
    private final JtwigPosition position;
    private CompilableExpression expression;

    public Filter(JtwigPosition position, CompilableExpression expression) {
        this.position = position;
        this.expression = expression;
    }

    @Override
    public Renderable compile(CompileContext context) throws CompileException {
        if (this.expression instanceof OperationBinary) {
            OperationBinary operationBinary = (OperationBinary)this.expression;
            operationBinary.transformFirst(this.toSpecialFunction());
        }
        return new Compiled(this.position, super.compile(context), this.expression.compile(context));
    }

    private Function<CompilableExpression, CompilableExpression> toSpecialFunction() {
        return new Function<CompilableExpression, CompilableExpression>(){

            public CompilableExpression apply(CompilableExpression input) {
                return new DelegateCompilable((FunctionElement)input);
            }
        };
    }

    private static Expression valueOf(final String value) {
        return new Expression(){

            @Override
            public Object calculate(RenderContext context) throws CalculateException {
                return value;
            }
        };
    }

    public static class DelegateCalculable
    implements Expression {
        private FunctionElement.Compiled function;

        public DelegateCalculable(FunctionElement.Compiled function) {
            this.function = function;
        }

        public DelegateCalculable withArgument(String value) {
            this.function = this.function.cloneAndAddArgument(Filter.valueOf(value));
            return this;
        }

        @Override
        public Object calculate(RenderContext context) throws CalculateException {
            return this.function.calculate(context);
        }
    }

    private class DelegateCompilable
    implements CompilableExpression {
        private final FunctionElement delegate;

        public DelegateCompilable(FunctionElement delegate) {
            this.delegate = delegate;
        }

        @Override
        public Expression compile(CompileContext context) throws CompileException {
            FunctionElement.Compiled compile = (FunctionElement.Compiled)this.delegate.compile(context);
            return new DelegateCalculable(compile);
        }
    }

    private static class Compiled
    implements Renderable {
        private final JtwigPosition position;
        private final Renderable content;
        private Expression expression;

        private Compiled(JtwigPosition position, Renderable content, Expression expression) {
            this.position = position;
            this.content = content;
            this.expression = expression;
        }

        @Override
        public void render(RenderContext context) throws RenderException {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.content.render(context.newRenderContext(outputStream));
            try {
                if (this.expression instanceof DelegateCalculable) {
                    ((DelegateCalculable)this.expression).withArgument(outputStream.toString());
                } else {
                    this.getDelegateExpression(this.position, (FunctionElement.Compiled)this.expression).withArgument(outputStream.toString());
                }
                context.write(String.valueOf(this.expression.calculate(context)).getBytes());
            }
            catch (CalculateException | IOException e) {
                throw new RenderException(e);
            }
        }

        private DelegateCalculable getDelegateExpression(JtwigPosition position, FunctionElement.Compiled function) {
            Expression firstArgument = function.getFirstArgument();
            if (firstArgument instanceof DelegateCalculable) {
                return (DelegateCalculable)firstArgument;
            }
            if (firstArgument instanceof FunctionElement.Compiled && ((FunctionElement.Compiled)firstArgument).hasArguments()) {
                return this.getDelegateExpression(position, (FunctionElement.Compiled)firstArgument);
            }
            throw new RuntimeException(position + ": Unable to find function to replace input.");
        }
    }
}

