/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.addons.tag;

import com.google.common.base.Function;
import com.lyncode.jtwig.addons.AddonModel;
import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.render.RenderContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Tag
extends AddonModel<Tag> {
    private final Function<String, String> transformation;

    public Tag(Function<String, String> transformation) {
        this.transformation = transformation;
    }

    @Override
    public Renderable compile(CompileContext context) throws CompileException {
        return new Compiled(super.compile(context), this.transformation);
    }

    private static class Compiled
    implements Renderable {
        private final Renderable content;
        private final Function<String, String> transformation;

        private Compiled(Renderable content, Function<String, String> transformation) {
            this.content = content;
            this.transformation = transformation;
        }

        @Override
        public void render(RenderContext context) throws RenderException {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.content.render(context.newRenderContext(outputStream));
            String result = (String)this.transformation.apply((Object)outputStream.toString());
            try {
                context.write(result.getBytes());
            }
            catch (IOException e) {
                throw new RenderException(e);
            }
        }
    }
}

