/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.compile;

import com.lyncode.jtwig.compile.config.CompileConfiguration;
import com.lyncode.jtwig.content.api.Compilable;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.content.model.compilable.Sequence;
import com.lyncode.jtwig.content.model.renderable.Replacement;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.exception.ResourceException;
import com.lyncode.jtwig.parser.JtwigParser;
import com.lyncode.jtwig.resource.JtwigResource;
import java.util.HashMap;
import java.util.Map;

public class CompileContext {
    private JtwigResource resource;
    private final JtwigParser parser;
    private final CompileConfiguration configuration;
    private Sequence parent;
    private Map<String, Renderable> replacements = new HashMap<String, Renderable>();

    public CompileContext(JtwigResource resource, JtwigParser parser, CompileConfiguration configuration) {
        this.resource = resource;
        this.parser = parser;
        this.configuration = configuration;
        this.parent = null;
    }

    public CompileContext withParent(Sequence element) {
        this.parent = element;
        return this;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Sequence parent() {
        return this.parent;
    }

    public CompileContext withReplacement(String name, Renderable replacement) {
        if (this.replacements.containsKey(name)) {
            this.replacements.put(name, new Replacement(this.replacements.get(name), replacement));
        } else {
            this.replacements.put(name, replacement);
        }
        return this;
    }

    public CompileContext withReplacement(Map<String, Renderable> replacements) {
        this.replacements.putAll(replacements);
        return this;
    }

    public boolean hasReplacement(String name) {
        return this.replacements.containsKey(name);
    }

    public Renderable replacement(String name) {
        return this.replacements.get(name);
    }

    public JtwigResource retrieve(String relativePath) throws ResourceException {
        return this.resource.resolve(relativePath);
    }

    public Compilable parse(JtwigResource resource) throws ParseException {
        return this.parser.parse(resource);
    }

    public CompileContext clone() {
        CompileContext compileContext = new CompileContext(this.resource, this.parser, this.configuration);
        compileContext.withParent(this.parent).withReplacement(this.replacements);
        return compileContext;
    }

    public CompileContext withResource(JtwigResource retrieve) {
        this.resource = retrieve;
        return this;
    }
}

