/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.content.model.compilable;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.content.api.Compilable;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.content.model.compilable.AbstractElement;
import com.lyncode.jtwig.content.model.compilable.Block;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.exception.ResourceException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.resource.JtwigResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Extends
extends AbstractElement {
    private final String resourcePath;
    private final CompilableExpression expr;
    private final List<Block> blocks = new ArrayList<Block>();

    public Extends(CompilableExpression expr) {
        this.resourcePath = null;
        this.expr = expr;
    }

    public Extends(String resourcePath) {
        this.resourcePath = resourcePath;
        this.expr = null;
    }

    @Override
    public Renderable compile(CompileContext context) throws CompileException {
        try {
            if (this.expr != null) {
                return new Compiled(this.expr.compile(context), context, this.blocks);
            }
            if (this.resourcePath != null) {
                JtwigResource extendResource = context.retrieve(this.resourcePath);
                CompileContext newContext = context.clone().withResource(extendResource);
                for (Block block : this.blocks) {
                    newContext.withReplacement(block.name(), block.compile(context));
                }
                Compilable parsed = newContext.parse(extendResource);
                return parsed.compile(newContext);
            }
            throw new CompileException("Invalid extends syntax. Neither string or expression resource path provided");
        }
        catch (ParseException | ResourceException e) {
            throw new CompileException(e);
        }
    }

    public Extends add(Block block) {
        this.blocks.add(block);
        return this;
    }

    public static class Compiled
    implements Renderable {
        private final Expression resourcePathExpression;
        private final CompileContext globalContext;
        private final List<Block> blocks;

        public Compiled(Expression resourcePathExpression, CompileContext globalContext, List<Block> blocks) {
            this.resourcePathExpression = resourcePathExpression;
            this.globalContext = globalContext;
            this.blocks = blocks;
        }

        @Override
        public void render(RenderContext context) throws RenderException {
            try {
                Object obj = this.resourcePathExpression.calculate(context);
                JtwigResource extendedResource = null;
                if (obj instanceof Collection) {
                    Object o;
                    Collection col = (Collection)obj;
                    Iterator<Object> i$ = col.iterator();
                    while (i$.hasNext() && (extendedResource = this.find((o = i$.next()).toString())) == null) {
                    }
                } else if (obj instanceof String) {
                    extendedResource = this.globalContext.retrieve(obj.toString());
                }
                if (extendedResource == null) {
                    throw new ResourceException("No resource found for extends tag");
                }
                CompileContext localContext = this.globalContext.clone().withResource(extendedResource);
                for (Block block : this.blocks) {
                    localContext.withReplacement(block.name(), block.compile(this.globalContext));
                }
                Compilable parsed = localContext.parse(extendedResource);
                Renderable r = parsed.compile(localContext);
                r.render(context);
            }
            catch (CalculateException | CompileException | ParseException | ResourceException ex) {
                throw new RenderException(ex);
            }
        }

        protected JtwigResource find(String name) {
            try {
                return this.globalContext.retrieve(name);
            }
            catch (ResourceException resourceException) {
                return null;
            }
        }
    }
}

