/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.content.model.compilable;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.content.model.compilable.Content;
import com.lyncode.jtwig.content.model.compilable.Sequence;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.types.Undefined;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class For
extends Content<For> {
    private final String key;
    private final String value;
    private final CompilableExpression collection;
    private Sequence elseContent;

    public For(String value, CompilableExpression collection) {
        this(null, value, collection);
    }

    public For(String key, String value, CompilableExpression collection) {
        this.key = key;
        this.value = value;
        this.collection = collection;
    }

    @Override
    public Renderable compile(CompileContext context) throws CompileException {
        Renderable elseContent = null;
        if (this.elseContent != null) {
            elseContent = this.elseContent.compile(context);
        }
        return new Compiled(super.compile(context), this.collection.compile(context), elseContent, this.key, this.value);
    }

    public For withElse(Sequence content) {
        this.elseContent = content.withParent(this);
        return this;
    }

    public static class Loop {
        private int index = 0;
        private int length;

        public Loop(int length) {
            this.length = length;
        }

        public void update(int index) {
            this.index = index;
        }

        public int getLength() {
            return this.length;
        }

        public int getIndex0() {
            return this.index;
        }

        public int getIndex() {
            return this.index + 1;
        }

        public int getRevindex0() {
            return this.length - this.index - 1;
        }

        public int getRevindex() {
            return this.length - this.index;
        }

        public boolean isFirst() {
            return this.index == 0;
        }

        public boolean isLast() {
            return this.index == this.length - 1;
        }
    }

    static class Compiled
    implements Renderable {
        private final Renderable iterationContent;
        private final Expression collection;
        private final Renderable elseContent;
        private final String key;
        private final String value;

        public Compiled(Renderable iterationContent, Expression collection, Renderable elseContent, String key, String value) {
            this.iterationContent = iterationContent;
            this.collection = collection;
            this.elseContent = elseContent;
            this.key = key;
            this.value = value;
        }

        @Override
        public void render(RenderContext context) throws RenderException {
            block8: {
                try {
                    List<Object> resolved = this.collection.calculate(context);
                    if (resolved == null) {
                        this.renderElse(context);
                        return;
                    }
                    while (resolved instanceof Expression) {
                        resolved = ((Expression)((Object)resolved)).calculate(context);
                    }
                    if (resolved instanceof Undefined) {
                        this.renderElse(context);
                        return;
                    }
                    if (resolved.getClass().isArray()) {
                        resolved = Arrays.asList(resolved);
                    }
                    if (resolved instanceof Map) {
                        this.handleMap((Map)((Object)resolved), context);
                        break block8;
                    }
                    if (resolved instanceof Collection) {
                        this.handleCollection(resolved, context);
                        break block8;
                    }
                    throw new RenderException("Expecting a map as parameter for the loop but " + this.collection + " was given");
                }
                catch (CalculateException ex) {
                    throw new RenderException(ex);
                }
            }
        }

        protected void handleMap(Map map, RenderContext context) throws RenderException {
            if (map.isEmpty()) {
                this.renderElse(context);
            }
            Loop loop = new Loop(map.size());
            context.with("loop", loop);
            int index = 0;
            for (Object k : map.keySet()) {
                loop.update(index++);
                if (this.key != null) {
                    context.with(this.key, k);
                }
                context.with(this.value, map.get(k));
                this.iterationContent.render(context);
            }
        }

        protected void handleCollection(Collection collection, RenderContext context) throws RenderException {
            if (collection.isEmpty()) {
                this.renderElse(context);
                return;
            }
            Loop loop = new Loop(collection.size());
            context.with("loop", loop);
            for (Object obj : collection) {
                if (this.key != null) {
                    context.with(this.key, loop.index);
                }
                context.with(this.value, obj);
                this.iterationContent.render(context);
                loop.index++;
            }
        }

        protected void renderElse(RenderContext context) throws RenderException {
            if (this.elseContent != null) {
                this.elseContent.render(context);
            }
        }
    }
}

