/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.content.model.compilable;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.content.model.compilable.AbstractElement;
import com.lyncode.jtwig.content.model.compilable.Content;
import com.lyncode.jtwig.content.model.tag.TagInformation;
import com.lyncode.jtwig.content.model.tag.WhiteSpaceControl;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.util.BooleanOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IfControl
extends AbstractElement {
    private List<Case> cases = new ArrayList<Case>();

    public IfControl add(Case aCase) {
        this.cases.add(aCase);
        return this;
    }

    @Override
    public TagInformation tag() {
        return new TagInformation(){

            @Override
            public WhiteSpaceControl whiteSpaceControl() {
                return new WhiteSpaceControl(){

                    @Override
                    public boolean trimBeforeBegin() {
                        return ((Case)IfControl.this.cases.get(0)).tag().whiteSpaceControl().trimBeforeBegin();
                    }

                    @Override
                    public boolean trimAfterBegin() {
                        return ((Case)IfControl.this.cases.get(0)).tag().whiteSpaceControl().trimAfterBegin();
                    }

                    @Override
                    public boolean trimBeforeEnd() {
                        return ((Case)IfControl.this.cases.get(IfControl.this.cases.size() - 1)).tag().whiteSpaceControl().trimBeforeEnd();
                    }

                    @Override
                    public boolean trimAfterEnd() {
                        return ((Case)IfControl.this.cases.get(IfControl.this.cases.size() - 1)).tag().whiteSpaceControl().trimAfterEnd();
                    }
                };
            }
        };
    }

    @Override
    public Renderable compile(CompileContext context) throws CompileException {
        ArrayList<CompiledCase> cases = new ArrayList<CompiledCase>();
        for (Case aCase : this.cases) {
            cases.add((CompiledCase)aCase.compile(context));
        }
        return new Compiled(cases);
    }

    private static class CompiledCase
    implements Renderable {
        private final Expression expression;
        private final Renderable content;

        public CompiledCase(Expression expression, Renderable content) {
            this.expression = expression;
            this.content = content;
        }

        public boolean conditionIsTrue(RenderContext context) throws RenderException {
            try {
                return BooleanOperations.isTrue(this.expression.calculate(context));
            }
            catch (CalculateException e) {
                throw new RenderException(e);
            }
        }

        @Override
        public void render(RenderContext context) throws RenderException {
            this.content.render(context);
        }
    }

    private static class Compiled
    implements Renderable {
        private final Collection<CompiledCase> cases;

        public Compiled(Collection<CompiledCase> cases) {
            this.cases = cases;
        }

        @Override
        public void render(RenderContext context) throws RenderException {
            for (CompiledCase aCase : this.cases) {
                if (!aCase.conditionIsTrue(context)) continue;
                aCase.render(context);
                break;
            }
        }
    }

    public static class Case
    extends Content<Case> {
        private CompilableExpression expression;

        public Case(CompilableExpression condition) {
            this.expression = condition;
        }

        @Override
        public Renderable compile(CompileContext context) throws CompileException {
            return new CompiledCase(this.expression.compile(context), super.compile(context));
        }
    }
}

