/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.content.model.compilable;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.content.model.compilable.AbstractElement;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.exception.ResourceException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.parser.model.JtwigPosition;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.resource.JtwigResource;
import java.util.Map;

public class Include
extends AbstractElement {
    private final String relativePath;
    private final JtwigPosition position;
    private CompilableExpression withExpression = null;
    private boolean ignoreMissing = false;
    private boolean isolated = false;

    public Include(JtwigPosition position, String relativePath) {
        this.position = position;
        this.relativePath = relativePath;
    }

    public Include with(CompilableExpression with) {
        this.withExpression = with;
        return this;
    }

    public Include setIsolated(boolean isolated) {
        this.isolated = isolated;
        return this;
    }

    public Include setIgnoreMissing(boolean ignoreMissing) {
        this.ignoreMissing = ignoreMissing;
        return this;
    }

    @Override
    public Renderable compile(CompileContext context) throws CompileException {
        try {
            JtwigResource resource = context.retrieve(this.relativePath);
            if (!resource.exists() && this.ignoreMissing) {
                return new Missing();
            }
            context = context.clone().withResource(resource);
            Compiled compiled = new Compiled(this.position, context.parse(resource).compile(context), this.isolated);
            if (this.withExpression != null) {
                compiled.with(this.withExpression.compile(context));
            }
            return compiled;
        }
        catch (ParseException | ResourceException e) {
            throw new CompileException(e);
        }
    }

    public static class Missing
    implements Renderable {
        @Override
        public void render(RenderContext context) throws RenderException {
        }
    }

    public static class Compiled
    implements Renderable {
        private final Renderable renderable;
        private final JtwigPosition position;
        private final boolean isolated;
        private Expression withExpression = null;

        public Compiled(JtwigPosition position, Renderable renderable, boolean isolated) {
            this.renderable = renderable;
            this.position = position;
            this.isolated = isolated;
        }

        public Compiled with(Expression expression) {
            this.withExpression = expression;
            return this;
        }

        @Override
        public void render(RenderContext context) throws RenderException {
            RenderContext usedContext = context;
            if (this.isolated) {
                usedContext = context.isolatedModel();
                ((Map)usedContext.map("model")).clear();
            }
            if (this.withExpression != null) {
                try {
                    Object calculate = this.withExpression.calculate(context);
                    if (!(calculate instanceof Map)) {
                        throw new RenderException(this.position + ": Include 'with' must be given a map.");
                    }
                    this.renderable.render(usedContext.with((Map)calculate));
                }
                catch (CalculateException e) {
                    throw new RenderException(e);
                }
            } else {
                this.renderable.render(usedContext);
            }
        }
    }
}

