/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.content.model.compilable;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.content.model.compilable.AbstractElement;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.util.TwigTransformUtils;
import java.io.IOException;

public class Output
extends AbstractElement {
    private final CompilableExpression expression;

    public Output(CompilableExpression expression) {
        this.expression = expression;
    }

    @Override
    public Renderable compile(CompileContext context) throws CompileException {
        return new Compiled(this.expression.compile(context));
    }

    private static class Compiled
    implements Renderable {
        private final Expression expression;

        private Compiled(Expression expression) {
            this.expression = expression;
        }

        @Override
        public void render(RenderContext context) throws RenderException {
            try {
                Object calculate = this.expression.calculate(context);
                if (calculate != null) {
                    context.write(TwigTransformUtils.toTwig(calculate).getBytes(context.configuration().charset()));
                }
            }
            catch (CalculateException | IOException e) {
                throw new RenderException(e);
            }
        }
    }
}

