/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.content.model.compilable;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.content.api.Compilable;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.content.model.compilable.AbstractElement;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.render.RenderContext;
import java.util.ArrayList;
import java.util.List;

public class Sequence
extends AbstractElement {
    private List<Compilable> contents = new ArrayList<Compilable>();
    private Compilable parent;
    private Compilable after;

    @Override
    public Renderable compile(CompileContext context) throws CompileException {
        ArrayList<Renderable> result = new ArrayList<Renderable>();
        context = context.clone().withParent(this);
        for (Compilable content : this.contents) {
            Renderable renderable = content.compile(context);
            if (renderable == Renderable.NOOP) continue;
            result.add(renderable);
        }
        return new Compiled(result);
    }

    public Sequence add(Compilable compilable) {
        this.contents.add(compilable);
        return this;
    }

    public Compilable previous(Compilable current) {
        int indexOf = this.contents.indexOf(current);
        if (indexOf > 0) {
            return this.contents.get(indexOf - 1);
        }
        return null;
    }

    public Compilable next(Compilable current) {
        int indexOf = this.contents.indexOf(current);
        if (indexOf < this.contents.size() - 1) {
            return this.contents.get(indexOf + 1);
        }
        return null;
    }

    public Sequence withParent(Compilable parent) {
        this.parent = parent;
        return this;
    }

    public Compilable parent() {
        return this.parent;
    }

    private static class Compiled
    implements Renderable {
        private List<Renderable> contents = new ArrayList<Renderable>();

        public Compiled(List<Renderable> result) {
            this.contents.addAll(result);
        }

        @Override
        public void render(RenderContext context) throws RenderException {
            for (Renderable content : this.contents) {
                content.render(context);
            }
        }
    }
}

