/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.content.model.compilable;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.content.model.compilable.AbstractElement;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.render.RenderContext;

public class SetVariable
extends AbstractElement {
    private final String variable;
    private final CompilableExpression assignment;

    public SetVariable(String variable, CompilableExpression assignment) {
        this.variable = variable;
        this.assignment = assignment;
    }

    @Override
    public Renderable compile(CompileContext context) throws CompileException {
        return new Compiled(this.variable, this.assignment.compile(context));
    }

    private static class Compiled
    implements Renderable {
        private final String variable;
        private final Expression assignment;

        private Compiled(String variable, Expression assignment) {
            this.variable = variable;
            this.assignment = assignment;
        }

        @Override
        public void render(RenderContext context) throws RenderException {
            try {
                context.with(this.variable, this.assignment.calculate(context));
            }
            catch (CalculateException e) {
                throw new RenderException(e);
            }
        }
    }
}

