/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.content.model.compilable;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.content.api.Compilable;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.content.api.Tag;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.render.RenderContext;
import java.io.IOException;

public class Text
implements Compilable {
    private final String text;

    public Text(String text) {
        this.text = text;
    }

    @Override
    public Renderable compile(CompileContext context) throws CompileException {
        String result = this.text;
        if (context.hasParent()) {
            Compilable before = context.parent().previous(this);
            Compilable after = context.parent().next(this);
            if (this.mustTrimAtRightOf(before, context)) {
                result = result.replaceAll("^\\s+", "");
            }
            if (this.mustTrimAtLeftOf(after, context)) {
                result = result.replaceAll("\\s+$", "");
            }
        }
        return new Compiled(result);
    }

    private boolean mustTrimAtLeftOf(Compilable element, CompileContext context) {
        if (element != null) {
            return element instanceof Tag && ((Tag)((Object)element)).tag().whiteSpaceControl().trimBeforeBegin();
        }
        Compilable container = context.parent().parent();
        if (container != null && container instanceof Tag) {
            return ((Tag)((Object)container)).tag().whiteSpaceControl().trimBeforeEnd();
        }
        return false;
    }

    private boolean mustTrimAtRightOf(Compilable element, CompileContext context) {
        if (element != null) {
            return element instanceof Tag && ((Tag)((Object)element)).tag().whiteSpaceControl().trimAfterEnd();
        }
        Compilable container = context.parent().parent();
        if (container != null && container instanceof Tag) {
            return ((Tag)((Object)container)).tag().whiteSpaceControl().trimAfterBegin();
        }
        return false;
    }

    public static class Builder
    implements Compilable {
        private final StringBuilder builder = new StringBuilder();

        public Builder append(String piece) {
            this.builder.append(piece);
            return this;
        }

        public Text build() {
            return new Text(this.builder.toString());
        }

        @Override
        public Renderable compile(CompileContext context) throws CompileException {
            return null;
        }
    }

    private static class Compiled
    implements Renderable {
        private final String value;

        public Compiled(String value) {
            this.value = value;
        }

        @Override
        public void render(RenderContext context) throws RenderException {
            try {
                context.write(this.value.getBytes());
            }
            catch (IOException e) {
                throw new RenderException(e);
            }
        }
    }
}

