/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.model;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.content.api.Renderable;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.exception.RenderException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.expressions.model.AbstractCompilableExpression;
import com.lyncode.jtwig.parser.model.JtwigPosition;
import com.lyncode.jtwig.render.RenderContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class BlockFunction
extends AbstractCompilableExpression {
    private final List<CompilableExpression> arguments = new ArrayList<CompilableExpression>();

    public BlockFunction(JtwigPosition position) {
        super(position);
    }

    public BlockFunction add(CompilableExpression argument) {
        this.arguments.add(argument);
        return this;
    }

    @Override
    public Expression compile(CompileContext context) throws CompileException {
        if (this.arguments.isEmpty()) {
            throw new CompileException("Block function requires a single argument");
        }
        ArrayList<Expression> compiledArguments = new ArrayList<Expression>();
        for (CompilableExpression argument : this.arguments) {
            compiledArguments.add(argument.compile(context));
        }
        return new Compiled(this.position(), compiledArguments, context);
    }

    public static class Compiled
    implements Expression {
        private final JtwigPosition position;
        private final List<Expression> arguments;
        private final CompileContext compileContext;

        public Compiled(JtwigPosition position, List<Expression> arguments, CompileContext compileContext) {
            this.position = position;
            this.arguments = new CopyOnWriteArrayList<Expression>(arguments);
            this.compileContext = compileContext;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object calculate(RenderContext context) throws CalculateException {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                RenderContext isolated = context.newRenderContext(baos);
                Renderable block = this.compileContext.replacement(this.getFirstArgument().calculate(isolated).toString());
                if (block != null) {
                    block.render(isolated);
                }
                String string = baos.toString();
                return string;
            }
            catch (IOException e) {
                return null;
            }
            catch (RenderException e) {
                throw new CalculateException("Unable to render the block.", e);
            }
        }

        public Expression getFirstArgument() {
            return this.arguments.get(0);
        }
    }
}

