/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.model;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.render.RenderContext;

public class Constant<T>
implements CompilableExpression {
    private T value;

    public Constant(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isInstanceOf(Class<?> clazzToTest) {
        return clazzToTest.isInstance(this.value);
    }

    public <S> S as(Class<S> type) {
        return type.cast(this.value);
    }

    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public Expression compile(CompileContext context) throws CompileException {
        return new Compiled(this.value);
    }

    public static class Compiled
    implements Expression {
        private final Object value;

        public Compiled(Object value) {
            this.value = value;
        }

        @Override
        public Object calculate(RenderContext context) throws CalculateException {
            return this.value;
        }
    }
}

