/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.model;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.expressions.model.AbstractCompilableExpression;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.exceptions.FunctionNotFoundException;
import com.lyncode.jtwig.functions.parameters.input.InputParameters;
import com.lyncode.jtwig.parser.model.JtwigPosition;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.util.ObjectExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class FunctionElement
extends AbstractCompilableExpression {
    private String name;
    private List<CompilableExpression> arguments = new ArrayList<CompilableExpression>();

    public FunctionElement(JtwigPosition position, String name) {
        super(position);
        this.name = name;
    }

    public FunctionElement add(CompilableExpression argument) {
        this.arguments.add(argument);
        return this;
    }

    @Override
    public Expression compile(CompileContext context) throws CompileException {
        ArrayList<Expression> compiledArguments = new ArrayList<Expression>();
        for (CompilableExpression argument : this.arguments) {
            compiledArguments.add(argument.compile(context));
        }
        return new Compiled(this.position(), this.name, compiledArguments);
    }

    public static class Compiled
    implements Expression {
        private final JtwigPosition position;
        private final String name;
        private final List<Expression> arguments;

        public Compiled(JtwigPosition position, String name, List<Expression> arguments) {
            this.position = position;
            this.name = name;
            this.arguments = new CopyOnWriteArrayList<Expression>(arguments);
        }

        private Object[] calculateArguments(RenderContext context) throws CalculateException {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Expression argument : this.arguments) {
                result.add(argument.calculate(context));
            }
            return result.toArray();
        }

        @Override
        public Object calculate(RenderContext context) throws CalculateException {
            try {
                try {
                    return context.executeFunction(this.name, InputParameters.parameters((Object[])this.calculateArguments(context)));
                }
                catch (FunctionNotFoundException e) {
                    throw new CalculateException(this.position + ": " + e.getMessage(), e);
                }
            }
            catch (FunctionException e) {
                throw new CalculateException(e);
            }
        }

        public Compiled cloneAndAddArgument(Expression expression) {
            ArrayList<Expression> arguments = new ArrayList<Expression>(this.arguments);
            arguments.add(0, expression);
            return new Compiled(this.position(), this.name, arguments);
        }

        public Object extract(RenderContext context, ObjectExtractor extractor) throws CalculateException, ObjectExtractor.ExtractException {
            return extractor.extract(this.name, this.calculateArguments(context));
        }

        public Expression getFirstArgument() {
            return this.arguments.get(0);
        }

        public JtwigPosition position() {
            return this.position;
        }

        public String name() {
            return this.name;
        }

        public boolean hasArguments() {
            return !this.arguments.isEmpty();
        }
    }
}

