/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.expressions.model;

import com.lyncode.jtwig.compile.CompileContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.CompileException;
import com.lyncode.jtwig.expressions.api.CompilableExpression;
import com.lyncode.jtwig.expressions.api.Expression;
import com.lyncode.jtwig.expressions.model.AbstractCompilableExpression;
import com.lyncode.jtwig.expressions.model.Variable;
import com.lyncode.jtwig.parser.model.JtwigPosition;
import com.lyncode.jtwig.render.RenderContext;
import com.lyncode.jtwig.types.Undefined;
import java.util.Map;

public class MapSelection
extends AbstractCompilableExpression {
    private final Variable variable;
    private final CompilableExpression key;

    public MapSelection(JtwigPosition position, Variable variable, CompilableExpression key) {
        super(position);
        this.variable = variable;
        this.key = key;
    }

    @Override
    public Expression compile(CompileContext context) throws CompileException {
        return new Compiled(this.position(), this.variable.compile(context), this.key.compile(context));
    }

    private static class Compiled
    implements Expression {
        private final JtwigPosition position;
        private final Expression variable;
        private final Expression key;

        private Compiled(JtwigPosition position, Expression variable, Expression key) {
            this.position = position;
            this.variable = variable;
            this.key = key;
        }

        @Override
        public Object calculate(RenderContext context) throws CalculateException {
            Object variableValue = this.variable.calculate(context);
            Object keyValue = this.key.calculate(context);
            if (keyValue instanceof Undefined) {
                throw new CalculateException(this.position + ": Given key is undefined");
            }
            if (variableValue instanceof Map) {
                Map map = (Map)variableValue;
                if (map.containsKey(keyValue)) {
                    return map.get(keyValue);
                }
                return Undefined.UNDEFINED;
            }
            throw new CalculateException(this.position + ": Unable to retrieve " + keyValue + " from " + variableValue);
        }
    }
}

